/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.spec.zone.responses;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.Srl;
import org.lastaflute.meta.SwaggerOption;
import org.lastaflute.meta.document.docmeta.ActionDocMeta;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.swagger.spec.parts.produces.SwaggerSpecProducesHandler;
import org.lastaflute.web.response.ApiResponse;
import org.lastaflute.web.response.HtmlResponse;
import org.lastaflute.web.response.StreamResponse;

public class SwaggerSpecResponsesSetupper {
    protected final SwaggerOption swaggerOption;
    protected final SwaggerSpecProducesHandler producesHandler;
    protected final Function<TypeDocMeta, Map<String, Object>> parameterMapProvider;

    public SwaggerSpecResponsesSetupper(SwaggerOption swaggerOption, SwaggerSpecProducesHandler producesHandler, Function<TypeDocMeta, Map<String, Object>> parameterMapProvider) {
        this.swaggerOption = swaggerOption;
        this.producesHandler = producesHandler;
        this.parameterMapProvider = parameterMapProvider;
    }

    public void prepareResponses(Map<String, Object> swaggerHttpMethodMap, ActionDocMeta actionDocMeta) {
        LinkedHashMap responseMap = DfCollectionUtil.newLinkedHashMap();
        swaggerHttpMethodMap.put("responses", responseMap);
        this.producesHandler.deriveProduces(actionDocMeta).ifPresent(produces -> swaggerHttpMethodMap.put("produces", produces));
        this.prepareResponseSuccess(responseMap, actionDocMeta);
        this.prepareResponseFailure(responseMap, actionDocMeta);
    }

    protected void prepareResponseSuccess(Map<String, Object> responseMap, ActionDocMeta actionDocMeta) {
        Integer httpStatus = this.findHttpStatus(actionDocMeta);
        String description = this.findDescription(actionDocMeta);
        Map<String, Object> contentMap = this.buildSuccessResponseContentMap(actionDocMeta, description);
        this.registerResponse(responseMap, httpStatus, contentMap);
    }

    protected Integer findHttpStatus(ActionDocMeta actionDocMeta) {
        return (Integer)this.swaggerOption.getSuccessHttpStatusLambda().map(callback -> (Integer)callback.apply(actionDocMeta)).orElseGet(() -> (Integer)actionDocMeta.getActionExecute().getSuccessHttpStatus().map(specified -> specified.getStatusValue()).orElse((Object)200));
    }

    protected String findDescription(ActionDocMeta actionDocMeta) {
        return (String)actionDocMeta.getActionExecute().getSuccessHttpStatus().map(specified -> {
            String specifiedDesc = specified.getDescription();
            return Srl.is_NotNull_and_NotTrimmedEmpty((String)specifiedDesc) ? specifiedDesc : null;
        }).orElse((Object)"success");
    }

    protected Map<String, Object> buildSuccessResponseContentMap(ActionDocMeta actionDocMeta, String description) {
        LinkedHashMap<String, Object> contentMap = this.newContentMapWithDescription(description);
        TypeDocMeta returnTypeDocMeta = actionDocMeta.getReturnTypeDocMeta();
        if (!Arrays.asList(HtmlResponse.class, StreamResponse.class).stream().anyMatch(clazz -> clazz.isAssignableFrom(returnTypeDocMeta.getType())) && !Arrays.asList(Void.TYPE, Void.class).contains(returnTypeDocMeta.getGenericType())) {
            Map<String, Object> parameterMap = this.parameterMapProvider.apply(returnTypeDocMeta);
            parameterMap.remove("name");
            parameterMap.remove("required");
            if (parameterMap.containsKey("schema")) {
                contentMap.putAll(parameterMap);
            } else {
                contentMap.put("schema", parameterMap);
            }
        }
        return contentMap;
    }

    protected void prepareResponseFailure(Map<String, Object> responseMap, ActionDocMeta actionDocMeta) {
        if (!ApiResponse.class.isAssignableFrom(actionDocMeta.getReturnTypeDocMeta().getType())) {
            return;
        }
        Map statusCauseMap = (Map)this.swaggerOption.getFailureHttpStatusLambda().map(callback -> {
            SwaggerOption.SwaggerFailureHttpStatusResource resource = (SwaggerOption.SwaggerFailureHttpStatusResource)callback.apply(actionDocMeta);
            return resource != null ? resource.getFailureStatusCauseMap() : null;
        }).orElseGet(() -> Collections.emptyMap());
        if (statusCauseMap.isEmpty()) {
            int httpStatus2 = 400;
            String description = "client error";
            LinkedHashMap<String, Object> contentMap = this.newContentMapWithDescription("client error");
            this.registerResponse(responseMap, 400, contentMap);
        } else {
            statusCauseMap.forEach((httpStatus, causeTypeList) -> {
                String description = causeTypeList.stream().map(tp -> tp.getSimpleName()).collect(Collectors.joining(", "));
                LinkedHashMap<String, Object> contentMap = this.newContentMapWithDescription(description);
                this.registerResponse(responseMap, (int)httpStatus, (Map<String, Object>)contentMap);
            });
        }
    }

    protected LinkedHashMap<String, Object> newContentMapWithDescription(String description) {
        return DfCollectionUtil.newLinkedHashMap((Object)"description", (Object)description);
    }

    protected void registerResponse(Map<String, Object> responseMap, int httpStatus, Map<String, Object> contentMap) {
        String statusExp = String.valueOf(httpStatus);
        responseMap.put(statusExp, contentMap);
    }
}

