/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.util.List;
import net.sf.log4jdbc.ResultSetCollector;
import org.slf4j.Logger;

public class ResultSetCollectorPrinter {
    private Logger log;
    private StringBuffer sb = new StringBuffer();

    public ResultSetCollectorPrinter(Logger log) {
        this.log = log;
    }

    public void printResultSet(ResultSetCollector resultSetCollector) {
        int colIndex;
        int column;
        int columnCount = resultSetCollector.getColumnCount();
        int[] maxLength = new int[columnCount];
        for (column = 1; column <= columnCount; ++column) {
            maxLength[column - 1] = resultSetCollector.getColumnName(column).length();
        }
        if (resultSetCollector.getRows() != null) {
            for (List<Object> printRow : resultSetCollector.getRows()) {
                colIndex = 0;
                for (Object v : printRow) {
                    int length;
                    if (v != null && (length = v.toString().length()) > maxLength[colIndex]) {
                        maxLength[colIndex] = length;
                    }
                    ++colIndex;
                }
            }
        }
        for (column = 1; column <= columnCount; ++column) {
            maxLength[column - 1] = maxLength[column - 1] + 1;
        }
        this.print("|");
        for (column = 1; column <= columnCount; ++column) {
            this.print(ResultSetCollectorPrinter.padRight("-", maxLength[column - 1]).replaceAll(" ", "-") + "|");
        }
        this.println();
        this.print("|");
        for (column = 1; column <= columnCount; ++column) {
            this.print(ResultSetCollectorPrinter.padRight(resultSetCollector.getColumnName(column), maxLength[column - 1]) + "|");
        }
        this.println();
        this.print("|");
        for (column = 1; column <= columnCount; ++column) {
            this.print(ResultSetCollectorPrinter.padRight("-", maxLength[column - 1]).replaceAll(" ", "-") + "|");
        }
        this.println();
        if (resultSetCollector.getRows() != null) {
            for (List<Object> printRow : resultSetCollector.getRows()) {
                colIndex = 0;
                this.print("|");
                for (Object v : printRow) {
                    this.print(ResultSetCollectorPrinter.padRight(v == null ? "null" : v.toString(), maxLength[colIndex]) + "|");
                    ++colIndex;
                }
                this.println();
            }
        }
        this.print("|");
        for (int column2 = 1; column2 <= columnCount; ++column2) {
            this.print(ResultSetCollectorPrinter.padRight("-", maxLength[column2 - 1]).replaceAll(" ", "-") + "|");
        }
        this.println();
        resultSetCollector.reset();
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String padLeft(String s, int n) {
        return String.format("%1$#" + n + "s", s);
    }

    void println() {
        this.log.info(this.sb.toString());
        this.sb.setLength(0);
    }

    void print(String s) {
        this.sb.append(s);
    }
}

