/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.netscape;

import java.util.Arrays;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPSocketFactory;
import org.ldaptive.ResultCode;
import org.ldaptive.provider.ControlHandler;
import org.ldaptive.provider.ControlProcessor;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.netscape.NetscapeControlHandler;

public class NetscapeProviderConfig
extends ProviderConfig<LDAPControl> {
    private LDAPConstraints ldapConstraints;
    private ResultCode[] searchIgnoreResultCodes;
    private LDAPSocketFactory ldapSocketFactory;

    public NetscapeProviderConfig() {
        this.setOperationExceptionResultCodes(new ResultCode[]{ResultCode.CONNECT_ERROR});
        this.setControlProcessor(new ControlProcessor((ControlHandler)new NetscapeControlHandler()));
        this.searchIgnoreResultCodes = new ResultCode[]{ResultCode.TIME_LIMIT_EXCEEDED, ResultCode.SIZE_LIMIT_EXCEEDED};
    }

    public LDAPConstraints getLDAPConstraints() {
        return this.ldapConstraints;
    }

    public void setLDAPConstraints(LDAPConstraints constraints) {
        this.checkImmutable();
        this.logger.trace("setting ldapConstraints: {}", (Object)constraints);
        this.ldapConstraints = constraints;
    }

    public ResultCode[] getSearchIgnoreResultCodes() {
        return this.searchIgnoreResultCodes;
    }

    public void setSearchIgnoreResultCodes(ResultCode[] codes) {
        this.checkImmutable();
        this.logger.trace("setting searchIgnoreResultCodes: {}", (Object)Arrays.toString(codes));
        this.searchIgnoreResultCodes = codes;
    }

    public LDAPSocketFactory getLDAPSocketFactory() {
        return this.ldapSocketFactory;
    }

    public void setLDAPSocketFactory(LDAPSocketFactory sf) {
        this.checkImmutable();
        this.logger.trace("setting ldapSocketFactory: {}", (Object)sf);
        this.ldapSocketFactory = sf;
    }

    public String toString() {
        return String.format("[%s@%d::operationExceptionResultCodes=%s, properties=%s, connectionStrategy=%s, controlProcessor=%s, ldapConstraints=%s, searchIgnoreResultCodes=%s, ldapSocketFactory=%s]", ((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).hashCode(), Arrays.toString(this.getOperationExceptionResultCodes()), this.getProperties(), this.getConnectionStrategy(), this.getControlProcessor(), this.ldapConstraints, Arrays.toString(this.searchIgnoreResultCodes), this.ldapSocketFactory);
    }
}

