/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.netscape;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSortKey;
import org.ldaptive.AttributeModification;
import org.ldaptive.AttributeModificationType;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchEntry;
import org.ldaptive.SortBehavior;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.control.SortKey;

public class NetscapeUtils {
    private final SortBehavior sortBehavior;
    private List<String> binaryAttrs;

    public NetscapeUtils() {
        this.sortBehavior = SortBehavior.getDefaultSortBehavior();
    }

    public NetscapeUtils(SortBehavior sb) {
        this.sortBehavior = sb;
    }

    public List<String> getBinaryAttributes() {
        return this.binaryAttrs;
    }

    public void setBinaryAttributes(String[] s) {
        if (s != null) {
            this.binaryAttrs = Arrays.asList(s);
        }
    }

    public LDAPAttribute fromLdapAttribute(LdapAttribute la) {
        LDAPAttribute attribute = new LDAPAttribute(la.getName());
        if (la.isBinary()) {
            for (byte[] b : la.getBinaryValues()) {
                attribute.addValue(b);
            }
        } else {
            for (String s : la.getStringValues()) {
                attribute.addValue(s);
            }
        }
        return attribute;
    }

    public LdapAttribute toLdapAttribute(LDAPAttribute a) {
        boolean isBinary = false;
        if (a.getName().contains(";binary")) {
            isBinary = true;
        } else if (this.binaryAttrs != null && this.binaryAttrs.contains(a.getName())) {
            isBinary = true;
        }
        LdapAttribute la = new LdapAttribute(this.sortBehavior, isBinary);
        la.setName(a.getName());
        if (isBinary) {
            la.addBinaryValue(a.getByteValueArray());
        } else {
            la.addStringValue(a.getStringValueArray());
        }
        return la;
    }

    public LDAPAttributeSet fromLdapAttributes(Collection<LdapAttribute> c) {
        LDAPAttributeSet attributes = new LDAPAttributeSet();
        for (LdapAttribute a : c) {
            attributes.add(this.fromLdapAttribute(a));
        }
        return attributes;
    }

    public SearchEntry toSearchEntry(LDAPEntry e, ResponseControl[] c, int id) {
        SearchEntry se = new SearchEntry(id, c, this.sortBehavior);
        se.setDn(e.getDN() != null ? e.getDN() : "");
        Enumeration en = e.getAttributeSet().getAttributes();
        while (en.hasMoreElements()) {
            se.addAttribute(new LdapAttribute[]{this.toLdapAttribute((LDAPAttribute)en.nextElement())});
        }
        return se;
    }

    public LDAPEntry fromLdapEntry(LdapEntry le) {
        return new LDAPEntry(le.getDn(), this.fromLdapAttributes(le.getAttributes()));
    }

    public LDAPModificationSet fromAttributeModification(AttributeModification[] am) {
        LDAPModificationSet mods = new LDAPModificationSet();
        for (AttributeModification anAm : am) {
            mods.add(NetscapeUtils.getModificationType(anAm.getAttributeModificationType()), this.fromLdapAttribute(anAm.getAttribute()));
        }
        return mods;
    }

    public static LDAPSortKey[] fromSortKey(SortKey[] sk) {
        LDAPSortKey[] keys = null;
        if (sk != null) {
            keys = new LDAPSortKey[sk.length];
            for (int i = 0; i < sk.length; ++i) {
                keys[i] = new LDAPSortKey(sk[i].getAttributeDescription(), sk[i].getReverseOrder(), sk[i].getMatchingRuleId());
            }
        }
        return keys;
    }

    protected static int getModificationType(AttributeModificationType am) {
        int type = -1;
        if (am == AttributeModificationType.ADD) {
            type = 0;
        } else if (am == AttributeModificationType.REMOVE) {
            type = 1;
        } else if (am == AttributeModificationType.REPLACE) {
            type = 2;
        }
        return type;
    }
}

