/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.netscape;

import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedOperation;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import org.ldaptive.AddRequest;
import org.ldaptive.BindRequest;
import org.ldaptive.CompareRequest;
import org.ldaptive.DeleteRequest;
import org.ldaptive.DerefAliases;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyDnRequest;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchReference;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.async.AsyncRequest;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.extended.ExtendedRequest;
import org.ldaptive.extended.ExtendedResponse;
import org.ldaptive.extended.ExtendedResponseFactory;
import org.ldaptive.extended.UnsolicitedNotificationListener;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.provider.ProviderUtils;
import org.ldaptive.provider.SearchItem;
import org.ldaptive.provider.SearchIterator;
import org.ldaptive.provider.SearchListener;
import org.ldaptive.provider.netscape.NetscapeProviderConfig;
import org.ldaptive.provider.netscape.NetscapeUtils;
import org.ldaptive.sasl.SaslConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetscapeConnection
implements ProviderConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LDAPConnection connection;
    private final NetscapeProviderConfig config;
    private int timeLimit;

    public NetscapeConnection(LDAPConnection lc, NetscapeProviderConfig pc) {
        this.connection = lc;
        this.config = pc;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int limit) {
        this.timeLimit = limit;
    }

    public LDAPConnection getLdapConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(RequestControl[] controls) throws LdapException {
        if (controls != null) {
            throw new UnsupportedOperationException("Provider does not support unbind with controls");
        }
        if (this.connection != null) {
            try {
                if (this.connection.isConnected()) {
                    this.connection.disconnect();
                }
            }
            catch (LDAPException e) {
                this.logger.warn("Error closing connection", (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    public Response<Void> bind(BindRequest request) throws LdapException {
        Response<Void> response = request.getSaslConfig() != null ? this.saslBind(request) : (request.getDn() == null && request.getCredential() == null ? this.anonymousBind(request) : this.simpleBind(request));
        return response;
    }

    protected Response<Void> anonymousBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            LDAPResponseListener listener = this.connection.bind(null, null, (LDAPResponseListener)null, this.getLDAPConstraints((Request)request));
            LDAPResponse r = listener.getResponse();
            response = this.createResponse((Request)request, null, r);
        }
        catch (LDAPException e) {
            this.processLDAPException(e);
        }
        return response;
    }

    protected Response<Void> simpleBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            LDAPResponseListener listener = this.connection.bind(request.getDn(), request.getCredential().getString(), (LDAPResponseListener)null, this.getLDAPConstraints((Request)request));
            LDAPResponse r = listener.getResponse();
            response = this.createResponse((Request)request, null, r);
        }
        catch (LDAPException e) {
            this.processLDAPException(e);
        }
        return response;
    }

    protected Response<Void> saslBind(BindRequest request) throws LdapException {
        Response response = null;
        try {
            SaslConfig sc = request.getSaslConfig();
            switch (sc.getMechanism()) {
                case EXTERNAL: {
                    this.connection.bind(null, new String[]{"EXTERNAL"}, null, (Object)null);
                    break;
                }
                case DIGEST_MD5: {
                    throw new UnsupportedOperationException("DIGEST-MD5 not supported");
                }
                case CRAM_MD5: {
                    throw new UnsupportedOperationException("CRAM-MD5 not supported");
                }
                case GSSAPI: {
                    throw new UnsupportedOperationException("GSSAPI not supported");
                }
                default: {
                    throw new IllegalArgumentException("Unknown SASL authentication mechanism: " + sc.getMechanism());
                }
            }
            response = new Response(null, ResultCode.SUCCESS);
        }
        catch (LDAPException e) {
            this.processLDAPException(e);
        }
        return response;
    }

    public Response<Void> add(AddRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            NetscapeUtils util = new NetscapeUtils();
            LDAPResponseListener listener = this.connection.add(new LDAPEntry(request.getDn(), util.fromLdapAttributes(request.getLdapAttributes())), (LDAPResponseListener)null, this.getLDAPConstraints((Request)request));
            LDAPResponse r = listener.getResponse();
            response = this.createResponse((Request)request, null, r);
        }
        catch (LDAPException e) {
            this.processLDAPException(e);
        }
        return response;
    }

    public Response<Boolean> compare(CompareRequest request) throws LdapException {
        Response<Boolean> response = null;
        try {
            NetscapeUtils util = new NetscapeUtils();
            LDAPResponseListener listener = this.connection.compare(request.getDn(), util.fromLdapAttribute(request.getAttribute()), (LDAPResponseListener)null, this.getLDAPConstraints((Request)request));
            LDAPResponse r = listener.getResponse();
            response = this.createResponse((Request)request, ResultCode.COMPARE_TRUE.value() == r.getResultCode(), r);
        }
        catch (LDAPException e) {
            this.processLDAPException(e);
        }
        return response;
    }

    public Response<Void> delete(DeleteRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            LDAPResponseListener listener = this.connection.delete(request.getDn(), (LDAPResponseListener)null, this.getLDAPConstraints((Request)request));
            LDAPResponse r = listener.getResponse();
            response = this.createResponse((Request)request, null, r);
        }
        catch (LDAPException e) {
            this.processLDAPException(e);
        }
        return response;
    }

    public Response<Void> modify(ModifyRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            NetscapeUtils util = new NetscapeUtils();
            LDAPResponseListener listener = this.connection.modify(request.getDn(), util.fromAttributeModification(request.getAttributeModifications()), (LDAPResponseListener)null, this.getLDAPConstraints((Request)request));
            LDAPResponse r = listener.getResponse();
            response = this.createResponse((Request)request, null, r);
        }
        catch (LDAPException e) {
            this.processLDAPException(e);
        }
        return response;
    }

    public Response<Void> modifyDn(ModifyDnRequest request) throws LdapException {
        Response response = null;
        try {
            String[] dn = request.getNewDn().split(",", 2);
            this.connection.rename(request.getDn(), dn[0], dn[1], request.getDeleteOldRDn(), this.getLDAPConstraints((Request)request));
            response = new Response(null, ResultCode.SUCCESS);
        }
        catch (LDAPException e) {
            this.processLDAPException(e);
        }
        return response;
    }

    public SearchIterator search(SearchRequest request) throws LdapException {
        NetscapeSearchIterator i = new NetscapeSearchIterator(request);
        i.initialize();
        return i;
    }

    public void searchAsync(SearchRequest request, SearchListener listener) throws LdapException {
        NetscapeAsyncSearchListener l = new NetscapeAsyncSearchListener(request, listener);
        l.initialize();
    }

    public void abandon(int messageId, RequestControl[] controls) throws LdapException {
        if (controls != null) {
            throw new UnsupportedOperationException("Provider does not support abandon with controls");
        }
        try {
            this.connection.abandon(messageId);
        }
        catch (LDAPException e) {
            this.processLDAPException(e);
        }
    }

    public Response<?> extendedOperation(ExtendedRequest request) throws LdapException {
        Response response = null;
        try {
            LDAPExtendedOperation op = this.connection.extendedOperation(new LDAPExtendedOperation(request.getOID(), request.encode()), this.getLDAPConstraints((Request)request));
            ExtendedResponse extRes = ExtendedResponseFactory.createExtendedResponse((String)request.getOID(), (String)op.getID(), (byte[])op.getValue());
            response = new Response(extRes.getValue(), ResultCode.SUCCESS);
        }
        catch (LDAPException e) {
            this.processLDAPException(e);
        }
        return response;
    }

    public void addUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
        throw new UnsupportedOperationException("Unsolicited notifications not supported");
    }

    public void removeUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
        throw new UnsupportedOperationException("Unsolicited notifications not supported");
    }

    protected LDAPConstraints getLDAPConstraints(Request request) {
        LDAPConstraints cons = new LDAPConstraints();
        this.initializeLDAPConstraints(request, cons);
        return cons;
    }

    protected void initializeLDAPConstraints(Request request, LDAPConstraints cons) {
        cons.setTimeLimit(this.timeLimit);
        cons.setServerControls((LDAPControl[])this.config.getControlProcessor().processRequestControls((RequestControl[])request.getControls()));
        if (request.getFollowReferrals()) {
            cons.setReferrals(request.getFollowReferrals());
            if (this.connection.getConstraints().getRebindProc() == null && this.connection.getAuthenticationDN() != null) {
                cons.setRebindProc(new LDAPRebind(){

                    public LDAPRebindAuth getRebindAuthentication(String host, int port) {
                        return new LDAPRebindAuth(NetscapeConnection.this.connection.getAuthenticationDN(), NetscapeConnection.this.connection.getAuthenticationPassword());
                    }
                });
            }
        }
    }

    protected void throwOperationException(Request request, LDAPResponse ldapResponse) throws LdapException {
        ProviderUtils.throwOperationException((ResultCode[])this.config.getOperationExceptionResultCodes(), (String)String.format("Ldap returned result code: %s", ldapResponse.getResultCode()), (int)ldapResponse.getResultCode(), (String)ldapResponse.getMatchedDN(), (ResponseControl[])this.config.getControlProcessor().processResponseControls((Object[])ldapResponse.getControls()), (String[])ldapResponse.getReferrals(), (boolean)false);
    }

    protected <T> Response<T> createResponse(Request request, T result, LDAPResponse ldapResponse) {
        return new Response(result, ResultCode.valueOf((int)ldapResponse.getResultCode()), ldapResponse.getErrorMessage(), ldapResponse.getMatchedDN(), this.config.getControlProcessor().processResponseControls((Object[])ldapResponse.getControls()), ldapResponse.getReferrals(), ldapResponse.getMessageID());
    }

    protected void processLDAPException(LDAPException e) throws LdapException {
        ProviderUtils.throwOperationException((ResultCode[])this.config.getOperationExceptionResultCodes(), (Exception)((Object)e), (int)(e instanceof LDAPReferralException ? ResultCode.REFERRAL.value() : e.getLDAPResultCode()), (String)e.getMatchedDN(), null, null, (boolean)true);
    }

    protected class NetscapeAsyncRequest
    implements AsyncRequest {
        private final LDAPSearchListener searchListener;

        public NetscapeAsyncRequest(LDAPSearchListener listener) {
            this.searchListener = listener;
        }

        public int getMessageId() {
            int[] ids = this.searchListener.getMessageIDs();
            if (ids == null || ids.length == 0) {
                return -1;
            }
            return ids[ids.length - 1];
        }

        public void abandon() throws LdapException {
            try {
                NetscapeConnection.this.connection.abandon(this.searchListener);
            }
            catch (LDAPException e) {
                NetscapeConnection.this.processLDAPException(e);
            }
        }

        public void abandon(RequestControl[] controls) throws LdapException {
            throw new UnsupportedOperationException("Cannot abandon operation with request controls");
        }
    }

    protected static class SearchResultIterator {
        private final LDAPSearchListener listener;
        private LDAPMessage message;
        private LDAPResponse response;

        public SearchResultIterator(LDAPSearchListener l) {
            this.listener = l;
        }

        public LDAPSearchListener getLDAPSearchListener() {
            return this.listener;
        }

        public boolean hasNext() throws LDAPException {
            if (this.response != null) {
                return false;
            }
            boolean more = false;
            this.message = this.listener.getResponse();
            if (this.message != null) {
                if (this.message instanceof LDAPSearchResult) {
                    more = true;
                } else if (this.message instanceof LDAPSearchResultReference) {
                    more = true;
                } else {
                    this.response = (LDAPResponse)this.message;
                }
            }
            return more;
        }

        public LDAPMessage next() {
            return this.message;
        }

        public LDAPResponse getResponse() {
            return this.response;
        }
    }

    protected abstract class AbstractNetscapeSearch {
        protected final SearchRequest request;
        protected final NetscapeUtils util;

        public AbstractNetscapeSearch(SearchRequest sr) {
            this.request = sr;
            this.util = new NetscapeUtils(this.request.getSortBehavior());
            this.util.setBinaryAttributes(this.request.getBinaryAttributes());
        }

        protected LDAPSearchListener search(LDAPConnection conn, SearchRequest sr) throws LDAPException {
            String[] retAttrs = sr.getReturnAttributes();
            if (retAttrs != null && retAttrs.length == 0) {
                retAttrs = new String[]{"1.1"};
            }
            return conn.search(sr.getBaseDn(), this.getSearchScope(sr.getSearchScope()), sr.getSearchFilter() != null ? sr.getSearchFilter().format() : null, retAttrs, sr.getTypesOnly(), (LDAPSearchListener)null, this.getLDAPSearchConstraints(this.request));
        }

        protected LDAPSearchConstraints getLDAPSearchConstraints(SearchRequest sr) throws LDAPException {
            LDAPSearchConstraints cons = new LDAPSearchConstraints();
            NetscapeConnection.this.initializeLDAPConstraints((Request)sr, (LDAPConstraints)cons);
            cons.setDereference(this.getDereference(this.request.getDerefAliases()));
            cons.setMaxResults((int)this.request.getSizeLimit());
            cons.setServerTimeLimit((int)this.request.getTimeLimit());
            return cons;
        }

        protected int getSearchScope(SearchScope ss) {
            int scope = 2;
            if (ss == SearchScope.OBJECT) {
                scope = 0;
            } else if (ss == SearchScope.ONELEVEL) {
                scope = 1;
            } else if (ss == SearchScope.SUBTREE) {
                scope = 2;
            }
            return scope;
        }

        protected int getDereference(DerefAliases da) {
            int deref = 0;
            if (da == DerefAliases.ALWAYS) {
                deref = 3;
            } else if (da == DerefAliases.FINDING) {
                deref = 2;
            } else if (da == DerefAliases.NEVER) {
                deref = 0;
            } else if (da == DerefAliases.SEARCHING) {
                deref = 1;
            }
            return deref;
        }

        protected ResultCode ignoreSearchException(ResultCode[] ignoreResultCodes, LDAPException e) {
            ResultCode ignore = null;
            if (ignoreResultCodes != null && ignoreResultCodes.length > 0) {
                for (ResultCode rc : ignoreResultCodes) {
                    if (e.getLDAPResultCode() != rc.value()) continue;
                    NetscapeConnection.this.logger.debug("Ignoring ldap exception", (Throwable)e);
                    ignore = rc;
                    break;
                }
            }
            return ignore;
        }

        protected SearchItem processLDAPSearchResult(LDAPSearchResult res) {
            NetscapeConnection.this.logger.trace("reading search result: {}", (Object)res);
            ResponseControl[] respControls = null;
            if (res.getControls() != null && res.getControls().length > 0) {
                respControls = NetscapeConnection.this.config.getControlProcessor().processResponseControls((Object[])res.getControls());
            }
            SearchEntry se = this.util.toSearchEntry(res.getEntry(), respControls, res.getMessageID());
            return new SearchItem(se);
        }

        protected SearchItem processLDAPSearchResultReference(LDAPSearchResultReference ref) {
            NetscapeConnection.this.logger.trace("reading search reference: {}", (Object)ref);
            ResponseControl[] respControls = null;
            if (ref.getControls() != null && ref.getControls().length > 0) {
                respControls = NetscapeConnection.this.config.getControlProcessor().processResponseControls((Object[])ref.getControls());
            }
            SearchReference sr = new SearchReference(ref.getMessageID(), respControls, ref.getUrls());
            return new SearchItem(sr);
        }
    }

    protected class NetscapeAsyncSearchListener
    extends AbstractNetscapeSearch {
        private final SearchListener listener;

        public NetscapeAsyncSearchListener(SearchRequest sr, SearchListener sl) {
            super(sr);
            this.listener = sl;
        }

        public void initialize() throws LdapException {
            try {
                this.search(NetscapeConnection.this.connection, this.request);
            }
            catch (LDAPException e) {
                NetscapeConnection.this.processLDAPException(e);
            }
        }

        @Override
        protected LDAPSearchListener search(LDAPConnection conn, SearchRequest sr) throws LDAPException {
            SearchResultIterator i = new SearchResultIterator(super.search(conn, sr));
            this.listener.asyncRequestReceived((AsyncRequest)new NetscapeAsyncRequest(i.getLDAPSearchListener()));
            while (i.hasNext()) {
                LDAPMessage message = i.next();
                if (message instanceof LDAPSearchResult) {
                    this.listener.searchItemReceived(this.processLDAPSearchResult((LDAPSearchResult)message));
                    continue;
                }
                if (message instanceof LDAPSearchResultReference) {
                    this.listener.searchItemReceived(this.processLDAPSearchResultReference((LDAPSearchResultReference)message));
                    continue;
                }
                throw new IllegalStateException("Unknown message: " + message);
            }
            Response<Object> response = NetscapeConnection.this.createResponse((Request)this.request, null, i.getResponse());
            this.listener.responseReceived(response);
            return null;
        }
    }

    protected class NetscapeSearchIterator
    extends AbstractNetscapeSearch
    implements SearchIterator {
        private Response<Void> response;
        private SearchResultIterator resultIterator;

        public NetscapeSearchIterator(SearchRequest sr) {
            super(sr);
        }

        public void initialize() throws LdapException {
            try {
                this.resultIterator = new SearchResultIterator(this.search(NetscapeConnection.this.connection, this.request));
            }
            catch (LDAPException e) {
                NetscapeConnection.this.processLDAPException(e);
            }
        }

        public boolean hasNext() throws LdapException {
            if (this.resultIterator == null || this.response != null) {
                return false;
            }
            boolean more = false;
            try {
                more = this.resultIterator.hasNext();
                if (!more) {
                    LDAPResponse res = this.resultIterator.getResponse();
                    NetscapeConnection.this.logger.trace("reading search response: {}", (Object)res);
                    NetscapeConnection.this.throwOperationException((Request)this.request, res);
                    this.response = NetscapeConnection.this.createResponse((Request)this.request, null, res);
                }
            }
            catch (LDAPException e) {
                ResultCode rc = this.ignoreSearchException(NetscapeConnection.this.config.getSearchIgnoreResultCodes(), e);
                if (rc == null) {
                    NetscapeConnection.this.processLDAPException(e);
                }
                this.response = new Response(null, rc, e.getLDAPErrorMessage(), e.getMatchedDN(), null, null, -1);
            }
            return more;
        }

        public SearchItem next() throws LdapException {
            SearchItem si;
            LDAPMessage message = this.resultIterator.next();
            if (message instanceof LDAPSearchResult) {
                si = this.processLDAPSearchResult((LDAPSearchResult)message);
            } else if (message instanceof LDAPSearchResultReference) {
                si = this.processLDAPSearchResultReference((LDAPSearchResultReference)message);
            } else {
                throw new IllegalStateException("Unknown message: " + message);
            }
            return si;
        }

        public Response<Void> getResponse() {
            return this.response;
        }

        public void close() throws LdapException {
        }
    }
}

