/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.kernel.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.ldp4j.application.kernel.resource.ResourceId;

final class AttachmentId {
    private final String id;
    private final ResourceId resourceId;

    private AttachmentId(String id, ResourceId resourceId) {
        this.resourceId = resourceId;
        this.id = id;
    }

    public ResourceId resourceId() {
        return this.resourceId;
    }

    public String id() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.resourceId});
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj.getClass() == this.getClass()) {
            AttachmentId that = (AttachmentId)obj;
            result = Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.resourceId, (Object)that.resourceId);
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id).add("resourceId", (Object)this.resourceId).toString();
    }

    public static AttachmentId createId(String attachmentId, ResourceId resourceId) {
        Preconditions.checkNotNull((Object)attachmentId, (Object)"Template identifier cannot be null");
        Preconditions.checkNotNull((Object)resourceId, (Object)"Resource identifier cannot be null");
        return new AttachmentId(attachmentId, resourceId);
    }
}

