/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.kernel.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ldp4j.application.kernel.constraints.ConstraintReport;
import org.ldp4j.application.kernel.constraints.ConstraintReportId;
import org.ldp4j.application.kernel.constraints.ConstraintReportRepository;
import org.ldp4j.application.kernel.lifecycle.LifecycleException;
import org.ldp4j.application.kernel.lifecycle.Managed;
import org.ldp4j.application.kernel.resource.Resource;
import org.ldp4j.application.kernel.resource.ResourceId;

final class InMemoryConstraintReportRepository
implements Managed,
ConstraintReportRepository {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Multimap<ResourceId, String> failureIds;
    private final Map<ConstraintReportId, ConstraintReport> reports = Maps.newLinkedHashMap();

    InMemoryConstraintReportRepository() {
        this.failureIds = LinkedHashMultimap.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintReport constraintReportOfId(ConstraintReportId id) {
        Preconditions.checkNotNull((Object)id, (Object)"Constraint report identifier cannot be null");
        this.lock.readLock().lock();
        try {
            ConstraintReport constraintReport = this.reports.get(id);
            return constraintReport;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ConstraintReport report) {
        Preconditions.checkNotNull((Object)report, (Object)"Constraint report cannot be null");
        this.lock.writeLock().lock();
        try {
            ConstraintReportId id = report.id();
            this.failureIds.put((Object)id.resourceId(), (Object)id.failureId());
            this.reports.put(id, report);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ConstraintReport report) {
        Preconditions.checkNotNull((Object)report, (Object)"Constraint report cannot be null");
        this.lock.writeLock().lock();
        try {
            ConstraintReportId reportId = report.id();
            this.failureIds.remove((Object)reportId.resourceId(), (Object)reportId.failureId());
            this.reports.remove(reportId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByResource(Resource resource) {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource cannot be null");
        this.lock.writeLock().lock();
        try {
            ResourceId resourceId = resource.id();
            for (String constraintsId : this.failureIds.get((Object)resourceId)) {
                this.reports.remove(ConstraintReportId.create((ResourceId)resourceId, (String)constraintsId));
            }
            this.failureIds.removeAll((Object)resourceId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void init() throws LifecycleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws LifecycleException {
        this.lock.writeLock().lock();
        try {
            this.reports.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

