/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.kernel.impl;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ldp4j.application.kernel.lifecycle.LifecycleException;
import org.ldp4j.application.kernel.lifecycle.Managed;
import org.ldp4j.application.kernel.resource.Container;
import org.ldp4j.application.kernel.resource.Resource;
import org.ldp4j.application.kernel.resource.ResourceId;
import org.ldp4j.application.kernel.resource.ResourceRepository;
import org.ldp4j.application.kernel.resource.ResourceVisitor;

final class InMemoryResourceRepository
implements Managed,
ResourceRepository {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<ResourceId, Resource> resources = new LinkedHashMap<ResourceId, Resource>();
    private final Map<ResourceId, Container> containers = new LinkedHashMap<ResourceId, Container>();

    InMemoryResourceRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource find(ResourceId id) {
        this.lock.readLock().lock();
        try {
            Resource result = this.resources.get(id);
            if (result == null) {
                result = (Resource)this.containers.get(id);
            }
            Resource resource = result;
            return resource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T extends Resource> T resourceById(ResourceId id, Class<? extends T> expectedResourceClass) {
        Preconditions.checkNotNull(expectedResourceClass, (Object)"Expected resource class cannot be null");
        Resource found = this.find(id);
        if (expectedResourceClass.isInstance(found)) {
            return (T)((Resource)expectedResourceClass.cast(found));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource resourceOfId(ResourceId id) {
        this.lock.readLock().lock();
        try {
            Resource resource = this.resources.get(id);
            return resource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container containerOfId(ResourceId id) {
        this.lock.readLock().lock();
        try {
            Container container = this.containers.get(id);
            return container;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Resource resource) {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource cannot be null");
        this.lock.writeLock().lock();
        try {
            Preconditions.checkState((this.find(resource.id()) == null ? 1 : 0) != 0, (String)"A resource with identifier '%s' already exists", (Object[])new Object[]{resource.id()});
            resource.accept(new ResourceVisitor(){

                public void visitResource(Resource resource) {
                    InMemoryResourceRepository.this.resources.put(resource.id(), resource);
                }

                public void visitContainer(Container resource) {
                    InMemoryResourceRepository.this.containers.put(resource.id(), resource);
                }
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Resource resource) {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource cannot be null");
        this.lock.writeLock().lock();
        try {
            this.resources.remove(resource.id());
            this.containers.remove(resource.id());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void init() throws LifecycleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws LifecycleException {
        this.lock.writeLock().lock();
        try {
            this.resources.clear();
            this.containers.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

