/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.kernel.impl;

import com.google.common.base.MoreObjects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldp4j.application.kernel.resource.Container;
import org.ldp4j.application.kernel.resource.ResourceId;
import org.ldp4j.application.kernel.resource.Slug;

final class InMemorySlug
implements Slug {
    private static final Pattern SLUG_PATH_PATTERN = Pattern.compile("(^.*)(_(\\d+)?$)");
    private final ResourceId containerId;
    private final String preferredPath;
    private long version;

    private InMemorySlug(ResourceId containerId, String preferredPath, long version) {
        this.containerId = containerId;
        this.preferredPath = preferredPath;
        this.version = version;
    }

    public ResourceId containerId() {
        return this.containerId;
    }

    public String preferredPath() {
        return this.preferredPath;
    }

    public synchronized long version() {
        return this.version;
    }

    synchronized void setVersion(long version) {
        this.version = version;
    }

    public synchronized String nextPath() {
        long id = this.version++;
        String result = this.preferredPath;
        if (id > 0L) {
            result = result + "_" + id;
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("containerId", (Object)this.containerId).add("preferredPath", (Object)this.preferredPath).add("version", this.version()).toString();
    }

    static InMemorySlug create(String slugPath, Container container) {
        String strPath;
        String strVersion;
        Matcher matcher = SLUG_PATH_PATTERN.matcher(slugPath);
        String path = slugPath;
        long version = 0L;
        if (matcher.matches() && (strVersion = matcher.group(3)) != null && !(strPath = matcher.group(1)).isEmpty()) {
            path = strPath;
            version = Long.parseLong(strVersion);
        }
        return new InMemorySlug(container.id(), path, version);
    }
}

