/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.kernel.impl;

import com.google.common.base.MoreObjects;
import org.ldp4j.application.kernel.impl.InMemoryTransactionManager;
import org.ldp4j.application.kernel.transaction.Transaction;

final class InMemoryTransaction
implements Transaction {
    private final InMemoryTransactionManager transactionManager;
    private final long id;
    private TransactionState state;

    InMemoryTransaction(long id, InMemoryTransactionManager persistencyManager) {
        this.id = id;
        this.transactionManager = persistencyManager;
        this.state = new PendingTransactionState();
    }

    long id() {
        return this.id;
    }

    public void begin() {
        this.state = this.state.begin();
    }

    public void commit() {
        this.state = this.state.commit();
    }

    public void rollback() {
        this.state = this.state.rollback();
    }

    public boolean isActive() {
        return this.state.isActive();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", this.id).add("state", (Object)this.state).add("persistencyManager", (Object)this.transactionManager).toString();
    }

    private final class CompletedTransactionState
    implements TransactionState {
        private static final String TRANSACTION_ALREADY_FINISHED = "Transaction already finished";
        private String message;

        private CompletedTransactionState(String message) {
            this.message = message;
        }

        @Override
        public TransactionState begin() {
            throw new IllegalStateException(TRANSACTION_ALREADY_FINISHED);
        }

        @Override
        public TransactionState commit() {
            throw new IllegalStateException(TRANSACTION_ALREADY_FINISHED);
        }

        @Override
        public TransactionState rollback() {
            throw new IllegalStateException(TRANSACTION_ALREADY_FINISHED);
        }

        public String toString() {
            return "completed (" + this.message + ")";
        }

        @Override
        public boolean isActive() {
            return false;
        }
    }

    private final class InFlightTransactionState
    implements TransactionState {
        private InFlightTransactionState() {
        }

        @Override
        public TransactionState begin() {
            throw new IllegalStateException("Transaction already initiated");
        }

        @Override
        public TransactionState commit() {
            InMemoryTransaction.this.transactionManager.disposeTransaction(InMemoryTransaction.this);
            return new CompletedTransactionState("commited");
        }

        @Override
        public TransactionState rollback() {
            InMemoryTransaction.this.transactionManager.disposeTransaction(InMemoryTransaction.this);
            return new CompletedTransactionState("rolledback");
        }

        public String toString() {
            return "in-flight";
        }

        @Override
        public boolean isActive() {
            return true;
        }
    }

    private final class PendingTransactionState
    implements TransactionState {
        private static final String TRANSACTION_NOT_INITIATED = "Transaction not initiated";

        private PendingTransactionState() {
        }

        @Override
        public TransactionState begin() {
            return new InFlightTransactionState();
        }

        @Override
        public TransactionState commit() {
            throw new IllegalStateException(TRANSACTION_NOT_INITIATED);
        }

        @Override
        public TransactionState rollback() {
            throw new IllegalStateException(TRANSACTION_NOT_INITIATED);
        }

        public String toString() {
            return "pending";
        }

        @Override
        public boolean isActive() {
            return false;
        }
    }

    private static interface TransactionState {
        public TransactionState begin();

        public TransactionState commit();

        public TransactionState rollback();

        public boolean isActive();
    }
}

