/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.kernel.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import org.ldp4j.application.kernel.impl.InMemoryTransaction;
import org.ldp4j.application.kernel.transaction.Transaction;
import org.ldp4j.application.kernel.transaction.TransactionManager;

final class InMemoryTransactionManager
implements TransactionManager {
    private final ThreadLocal<InMemoryTransaction> currentTransaction = new ThreadLocal();
    private final AtomicLong transactionCounter = new AtomicLong();

    public Transaction currentTransaction() {
        InMemoryTransaction transaction = this.currentTransaction.get();
        if (transaction == null) {
            transaction = new InMemoryTransaction(this.transactionCounter.getAndIncrement(), this);
            this.currentTransaction.set(transaction);
        }
        return transaction;
    }

    void disposeTransaction(InMemoryTransaction transaction) {
        Transaction current = this.currentTransaction.get();
        Preconditions.checkArgument((transaction == current ? 1 : 0) != 0, (Object)"Transactions can only be disposed by the their owner thread");
        this.currentTransaction.remove();
    }
}

