/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader.registries;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.legendofdragoon.modloader.events.registries.RegistryEvent;
import org.legendofdragoon.modloader.registries.DuplicateRegistryIdException;
import org.legendofdragoon.modloader.registries.Registry;
import org.legendofdragoon.modloader.registries.RegistryDelegate;
import org.legendofdragoon.modloader.registries.RegistryEntry;
import org.legendofdragoon.modloader.registries.RegistryId;

public class Registrar<Type extends RegistryEntry, EventType extends RegistryEvent.Register<Type>> {
    private final Registry<Type> registry;
    private final String modId;
    private final Map<RegistryId, Supplier<Type>> entries = new HashMap<RegistryId, Supplier<Type>>();

    public Registrar(Registry<Type> registry, String modId) {
        this.registry = registry;
        this.modId = modId;
    }

    public <T extends Type> RegistryDelegate<T> register(String entryId, Supplier<T> entry) {
        RegistryId id = new RegistryId(this.modId, entryId);
        if (this.entries.containsKey(id)) {
            throw new DuplicateRegistryIdException("Registry ID " + id + " already registered");
        }
        this.entries.put(id, entry);
        return this.registry.getEntry(id);
    }

    public void registryEvent(EventType registryEvent) {
        this.entries.forEach((entryId, supplier) -> registryEvent.register((RegistryId)entryId, (RegistryEntry)supplier.get()));
    }
}

