/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.legendofdragoon.modloader.ModState;

public class ModContainer {
    public final String modId;
    public final Object mod;
    ModState state = ModState.INITIALIZED;

    public ModContainer(String modId, Object mod) {
        this.modId = modId;
        this.mod = mod;
    }

    public URL getResource(String path) {
        return this.mod.getClass().getClassLoader().getResource(this.modId + "/" + path);
    }

    private URL getLangResource(Locale locale) {
        URL specific = this.getResource("lang/%s.lang".formatted(locale));
        if (specific != null) {
            return specific;
        }
        URL langCountry = this.getResource("lang/%s_%s.lang".formatted(locale.getLanguage(), locale.getCountry()));
        if (langCountry != null) {
            return langCountry;
        }
        URL lang = this.getResource("lang/%s.lang".formatted(locale.getLanguage()));
        if (lang != null) {
            return lang;
        }
        return this.getResource("lang/en.lang");
    }

    public Map<String, String> loadLang(Locale locale) throws IOException {
        URL langUrl = this.getLangResource(locale);
        if (langUrl == null) {
            return Map.of();
        }
        HashMap<String, String> lang = new HashMap<String, String>();
        Properties properties = new Properties();
        properties.load(langUrl.openStream());
        for (Object key : properties.keySet()) {
            lang.put((String)key, properties.getProperty((String)key));
        }
        return lang;
    }
}

