/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader.registries;

import org.legendofdragoon.modloader.registries.DuplicateRegistryIdException;
import org.legendofdragoon.modloader.registries.Registry;
import org.legendofdragoon.modloader.registries.RegistryDelegate;
import org.legendofdragoon.modloader.registries.RegistryEntry;
import org.legendofdragoon.modloader.registries.RegistryId;
import org.legendofdragoon.modloader.registries.RegistryLockedException;

public class MutableRegistry<Type extends RegistryEntry>
extends Registry<Type> {
    private boolean locked;

    public Type register(RegistryId id, Type entry) {
        if (this.locked) {
            throw new RegistryLockedException();
        }
        if (this.entries.containsKey(id)) {
            throw new DuplicateRegistryIdException("Registry ID " + String.valueOf(id) + " already registered");
        }
        ((RegistryEntry)entry).setRegistryId(id);
        this.entries.put(id, entry);
        return entry;
    }

    void lock() {
        this.locked = true;
    }

    void reset() {
        this.locked = false;
        for (RegistryDelegate delegate : this.delegates.values()) {
            delegate.clear();
        }
        this.entries.clear();
    }
}

