/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceMap;
import org.legendofdragoon.modloader.registries.RegistryDelegate;
import org.legendofdragoon.modloader.registries.RegistryEntry;
import org.legendofdragoon.modloader.registries.RegistryId;

public class Registry<Type extends RegistryEntry>
implements Iterable<RegistryId> {
    protected final Map<RegistryId, Type> entries = new HashMap<RegistryId, Type>();
    protected final Map<RegistryId, RegistryDelegate<Type>> delegates = new ReferenceMap();

    public boolean hasEntry(RegistryId id) {
        return this.entries.containsKey(id);
    }

    public RegistryDelegate<Type> getEntry(RegistryId id) {
        return this.delegates.computeIfAbsent(id, key -> new RegistryDelegate<RegistryEntry>(id, this, this.getClass(), () -> (RegistryEntry)this.entries.get(key)));
    }

    public RegistryDelegate<Type> getEntry(String id) {
        return this.getEntry(RegistryId.of(id));
    }

    public RegistryDelegate<Type> getEntry(String modId, String entryId) {
        return this.getEntry(new RegistryId(modId, entryId));
    }

    @Override
    public Iterator<RegistryId> iterator() {
        return this.entries.keySet().iterator();
    }
}

