/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader.registries;

import java.util.function.Supplier;
import org.legendofdragoon.modloader.Latch;
import org.legendofdragoon.modloader.ModNotLoadedException;
import org.legendofdragoon.modloader.registries.Registry;
import org.legendofdragoon.modloader.registries.RegistryEntry;
import org.legendofdragoon.modloader.registries.RegistryId;

public class RegistryDelegate<Type extends RegistryEntry> {
    private final RegistryId id;
    private final Registry<Type> registry;
    private final Class<Registry<Type>> cls;
    private final Latch<Type> latch;

    RegistryDelegate(RegistryId id, Registry<Type> registry, Class<Registry<Type>> cls, Supplier<Type> supplier) {
        this.id = id;
        this.registry = registry;
        this.cls = cls;
        this.latch = new Latch<Type>(supplier);
    }

    public boolean isValid() {
        return this.registry.hasEntry(this.id);
    }

    public void clear() {
        this.latch.clear();
    }

    public Type get() {
        if (!this.isValid()) {
            throw new ModNotLoadedException("Mod " + this.id.modId() + " is not loaded");
        }
        return (Type)((RegistryEntry)this.latch.get());
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegistryDelegate) {
            RegistryDelegate other = (RegistryDelegate)obj;
            return this.cls.equals(other.cls) && this.id.equals(other.id);
        }
        return false;
    }
}

