/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.legendofdragoon.modloader.Mod;
import org.legendofdragoon.modloader.ModContainer;
import org.legendofdragoon.modloader.ModState;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class ModManager {
    private static final Logger LOGGER = LogManager.getFormatterLogger(ModManager.class);
    private final Map<String, URL> allModUrls = new HashMap<String, URL>();
    private final Map<String, Class<?>> allModClasses = new HashMap();
    private final Set<String> allModIds = Collections.unmodifiableSet(this.allModClasses.keySet());
    private final List<URL> loadedModUrls = new ArrayList<URL>();
    private final Map<String, ModContainer> loadedModInstances = new HashMap<String, ModContainer>();
    private final Map<ClassLoader, ModContainer> loadedModInstancesByClassloader = new HashMap<ClassLoader, ModContainer>();
    private final Collection<ModContainer> unmodifiableLoadedModInstances = Collections.unmodifiableCollection(this.loadedModInstances.values());

    public ModManager(Consumer<Access> access) {
        access.accept(new Access());
    }

    public Set<String> getAllModIds() {
        return this.allModIds;
    }

    public boolean isLoaded(String modId) {
        return this.loadedModInstances.containsKey(modId);
    }

    public boolean isReady(String modId) {
        return this.loadedModInstances.containsKey(modId) && this.loadedModInstances.get((Object)modId).state.isReady();
    }

    public Collection<ModContainer> getLoadedMods() {
        return this.unmodifiableLoadedModInstances;
    }

    public void setActiveModByClassloader(@Nullable ClassLoader classLoader) {
        if (classLoader == null || classLoader == ModManager.class.getClassLoader()) {
            ModContainer.setActiveMod(null);
        } else {
            ModContainer.setActiveMod(this.loadedModInstancesByClassloader.get(classLoader));
        }
    }

    public ConfigurationBuilder addModsToReflectionsConfig(ConfigurationBuilder builder) {
        return builder.addUrls(new URL[]{this.getClass().getClassLoader().getResource("")}).addClassLoaders(new ClassLoader[]{this.getClass().getClassLoader()}).addUrls(ClasspathHelper.forPackage((String)"legend", (ClassLoader[])new ClassLoader[0])).addClassLoaders((ClassLoader[])this.loadedModInstances.values().stream().map(ModContainer::getClassLoader).toArray(ClassLoader[]::new)).addUrls(this.loadedModUrls);
    }

    public class Access {
        private Access() {
        }

        public void findMods() throws IOException {
            Path modsDir = Path.of("./mods", new String[0]);
            Files.createDirectories(modsDir, new FileAttribute[0]);
            LOGGER.info("Scanning for mods...");
            ArrayList<URL> urlList = new ArrayList<URL>();
            try (DirectoryStream<Path> jars = Files.newDirectoryStream(modsDir, "*.jar");){
                for (Path jar : jars) {
                    urlList.add(jar.toUri().toURL());
                }
            }
            ClassLoader[] modClassLoaders = new ClassLoader[urlList.size()];
            for (int i = 0; i < modClassLoaders.length; ++i) {
                modClassLoaders[i] = new URLClassLoader(new URL[]{(URL)urlList.get(i)});
            }
            ModManager.this.allModUrls.clear();
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(new URL[]{this.getClass().getClassLoader().getResource("")}).addClassLoaders(new ClassLoader[]{this.getClass().getClassLoader()}).addUrls(ClasspathHelper.forPackage((String)"legend", (ClassLoader[])new ClassLoader[0])).addClassLoaders(modClassLoaders).addUrls(urlList));
            Set modClasses = reflections.getTypesAnnotatedWith(Mod.class);
            for (Class modClass : modClasses) {
                Mod modAnnotation = modClass.getDeclaredAnnotation(Mod.class);
                if (ModManager.this.allModClasses.containsKey(modAnnotation.id())) {
                    LOGGER.error("Duplicate mod ID %s! Skipping.", (Object)modAnnotation.id());
                    continue;
                }
                LOGGER.info("Found mod: %s", (Object)modAnnotation.id());
                ModManager.this.allModClasses.put(modAnnotation.id(), modClass);
                ModManager.this.allModUrls.put(modAnnotation.id(), modClass.getProtectionDomain().getCodeSource().getLocation());
            }
        }

        public void loadMods() {
            this.loadMods(ModManager.this.allModIds);
        }

        public Set<String> loadMods(Set<String> modIds) {
            ModManager.this.loadedModUrls.clear();
            HashSet<String> missingModIds = new HashSet<String>();
            for (String modId : modIds) {
                if (ModManager.this.allModClasses.containsKey(modId)) {
                    this.instantiateMod(modId);
                    continue;
                }
                missingModIds.add(modId);
            }
            return missingModIds;
        }

        private void instantiateMod(String modId) {
            try {
                ModContainer modContainer = new ModContainer(modId, ModManager.this.allModClasses.get(modId).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                ModManager.this.loadedModInstances.put(modId, modContainer);
                ModManager.this.loadedModInstancesByClassloader.put(modContainer.classLoader, modContainer);
                ModManager.this.loadedModUrls.add(ModManager.this.allModUrls.get(modId));
                LOGGER.info("Loaded mod: %s", (Object)modId);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                LOGGER.warn("FAILED TO LOAD MOD: %s", (Object)modId);
                LOGGER.warn("Exception:", (Throwable)ex);
            }
        }

        public void loadingComplete() {
            for (ModContainer container : ModManager.this.loadedModInstances.values()) {
                container.state = ModState.READY;
            }
        }

        public void reset() {
            ModManager.this.loadedModUrls.clear();
            ModManager.this.loadedModInstances.clear();
            ModManager.this.loadedModInstancesByClassloader.clear();
        }
    }
}

