/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader;

import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.legendofdragoon.modloader.MissingRequiredModException;
import org.legendofdragoon.modloader.Mod;
import org.legendofdragoon.modloader.ModContainer;
import org.legendofdragoon.modloader.ModState;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class ModManager {
    private static final Logger LOGGER = LogManager.getFormatterLogger(ModManager.class);
    private final Set<String> requiredModIds;
    private final Map<String, URL> allModUrls = new HashMap<String, URL>();
    private final Map<String, Class<?>> allModClasses = new HashMap();
    private final Set<String> allModIds = Collections.unmodifiableSet(this.allModClasses.keySet());
    private final Map<String, String> wrongVersion = new HashMap<String, String>();
    private final Map<String, String> failedToLoad = new HashMap<String, String>();
    private final List<URL> loadedModUrls = new ArrayList<URL>();
    private final Map<String, ModContainer> loadedModInstances = new HashMap<String, ModContainer>();
    private final Map<ClassLoader, ModContainer> loadedModInstancesByClassloader = new HashMap<ClassLoader, ModContainer>();
    private final Collection<ModContainer> unmodifiableLoadedModInstances = Collections.unmodifiableCollection(this.loadedModInstances.values());

    public ModManager(Consumer<Access> access, String ... requiredModIds) {
        access.accept(new Access());
        this.requiredModIds = Set.of(requiredModIds);
    }

    public Set<String> getRequiredModIds() {
        return this.requiredModIds;
    }

    public Set<String> getAllModIds() {
        return this.allModIds;
    }

    public Map<String, String> getWrongVersions() {
        return Collections.unmodifiableMap(this.wrongVersion);
    }

    public Map<String, String> getFailedToLoad() {
        return Collections.unmodifiableMap(this.failedToLoad);
    }

    public boolean isLoaded(String modId) {
        return this.loadedModInstances.containsKey(modId);
    }

    public boolean isReady(String modId) {
        return this.loadedModInstances.containsKey(modId) && this.loadedModInstances.get((Object)modId).state.isReady();
    }

    public Collection<ModContainer> getLoadedMods() {
        return this.unmodifiableLoadedModInstances;
    }

    public void setActiveModByClassloader(@Nullable ClassLoader classLoader) {
        if (classLoader == null || classLoader == ModManager.class.getClassLoader()) {
            ModContainer.setActiveMod(null);
        } else {
            ModContainer.setActiveMod(this.loadedModInstancesByClassloader.get(classLoader));
        }
    }

    public ConfigurationBuilder addModsToReflectionsConfig(ConfigurationBuilder builder) {
        return builder.addUrls(new URL[]{this.getClass().getClassLoader().getResource("")}).addClassLoaders(new ClassLoader[]{this.getClass().getClassLoader()}).addUrls(ClasspathHelper.forPackage((String)"legend", (ClassLoader[])new ClassLoader[0])).addClassLoaders((ClassLoader[])this.loadedModInstances.values().stream().map(ModContainer::getClassLoader).toArray(ClassLoader[]::new)).addUrls(this.loadedModUrls);
    }

    public class Access {
        private Access() {
        }

        public void findMods(Path modsDir, String gameVersion) throws IOException {
            Files.createDirectories(modsDir, new FileAttribute[0]);
            LOGGER.info("Scanning for mods...");
            ArrayList<URL> urlList = new ArrayList<URL>();
            try (DirectoryStream<Path> jars = Files.newDirectoryStream(modsDir, "*.jar");){
                for (Path jar : jars) {
                    urlList.add(jar.toUri().toURL());
                }
            }
            ClassLoader[] modClassLoaders = new ClassLoader[urlList.size()];
            for (int i = 0; i < modClassLoaders.length; ++i) {
                modClassLoaders[i] = new URLClassLoader(new URL[]{(URL)urlList.get(i)});
            }
            ModManager.this.allModUrls.clear();
            ModManager.this.wrongVersion.clear();
            ModManager.this.failedToLoad.clear();
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(new URL[]{this.getClass().getClassLoader().getResource("")}).addClassLoaders(new ClassLoader[]{this.getClass().getClassLoader()}).addUrls(ClasspathHelper.forPackage((String)"legend", (ClassLoader[])new ClassLoader[0])).addClassLoaders(modClassLoaders).addUrls(urlList));
            Set modClasses = reflections.getTypesAnnotatedWith(Mod.class);
            Semver semver = new Semver(gameVersion, Semver.SemverType.NPM);
            for (Class modClass : modClasses) {
                try {
                    Mod modAnnotation = modClass.getDeclaredAnnotation(Mod.class);
                    if (!semver.satisfies(modAnnotation.version())) {
                        LOGGER.warn("Mod %s is for another version! (%S)", (Object)modAnnotation.id(), (Object)modAnnotation.version());
                        ModManager.this.wrongVersion.put(modAnnotation.id(), modAnnotation.version());
                        continue;
                    }
                    if (ModManager.this.allModClasses.containsKey(modAnnotation.id())) {
                        LOGGER.error("Duplicate mod ID %s! Skipping.", (Object)modAnnotation.id());
                        ModManager.this.failedToLoad.put(modAnnotation.id(), "Duplicate mod ID");
                        continue;
                    }
                    LOGGER.info("Found mod: %s", (Object)modAnnotation.id());
                    ModManager.this.allModClasses.put(modAnnotation.id(), modClass);
                    ModManager.this.allModUrls.put(modAnnotation.id(), modClass.getProtectionDomain().getCodeSource().getLocation());
                }
                catch (IncompleteAnnotationException e) {
                    LOGGER.warn("Mod %s is for an old version!", (Object)modClass.getSimpleName());
                    LOGGER.warn("", (Throwable)e);
                    ModManager.this.wrongVersion.put(modClass.getSimpleName(), "Unknown");
                }
                catch (Throwable e) {
                    LOGGER.error("Mod ID %s failed to load!", (Object)modClass.getSimpleName());
                    LOGGER.error("", e);
                    ModManager.this.failedToLoad.put(modClass.getSimpleName(), "Failed to load");
                }
            }
            if (!ModManager.this.allModIds.containsAll(ModManager.this.requiredModIds)) {
                HashSet<String> missingMods = new HashSet<String>(ModManager.this.requiredModIds);
                missingMods.removeAll(ModManager.this.allModIds);
                throw new MissingRequiredModException("Missing required mods (" + String.join((CharSequence)", ", missingMods) + ")");
            }
        }

        public void loadMods() {
            this.loadMods(ModManager.this.allModIds);
        }

        public Set<String> loadMods(Set<String> modIds) {
            ModManager.this.loadedModUrls.clear();
            HashSet<String> modsToLoad = new HashSet<String>(modIds);
            modsToLoad.addAll(ModManager.this.requiredModIds);
            HashSet<String> missingModIds = new HashSet<String>();
            for (String modId : modsToLoad) {
                if (ModManager.this.allModClasses.containsKey(modId)) {
                    this.instantiateMod(modId);
                    continue;
                }
                missingModIds.add(modId);
            }
            return missingModIds;
        }

        private void instantiateMod(String modId) {
            try {
                ModContainer modContainer = new ModContainer(modId, ModManager.this.allModClasses.get(modId).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                ModManager.this.loadedModInstances.put(modId, modContainer);
                ModManager.this.loadedModInstancesByClassloader.put(modContainer.classLoader, modContainer);
                ModManager.this.loadedModUrls.add(ModManager.this.allModUrls.get(modId));
                LOGGER.info("Loaded mod: %s", (Object)modId);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                LOGGER.warn("FAILED TO LOAD MOD: %s", (Object)modId);
                LOGGER.warn("Exception:", (Throwable)ex);
                ModManager.this.failedToLoad.put(modId, "Failed to create mod instance");
                ModManager.this.allModClasses.remove(modId);
                ModManager.this.allModUrls.remove(modId);
            }
        }

        public void loadingComplete() {
            for (ModContainer container : ModManager.this.loadedModInstances.values()) {
                container.state = ModState.READY;
            }
        }

        public void reset() {
            ModManager.this.loadedModUrls.clear();
            ModManager.this.loadedModInstances.clear();
            ModManager.this.loadedModInstancesByClassloader.clear();
        }
    }
}

