/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.legendofdragoon.modloader.ModManager;
import org.legendofdragoon.modloader.events.Event;
import org.legendofdragoon.modloader.events.EventBinding;
import org.legendofdragoon.modloader.events.EventListener;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class EventManager {
    private static final Logger LOGGER = LogManager.getFormatterLogger(EventManager.class);
    private final Map<Class<?>, List<EventBinding>> listeners = new HashMap();
    private final Set<EventBinding> staleListeners = new HashSet<EventBinding>();
    private ModManager modManager;

    public EventManager(Consumer<Access> access) {
        access.accept(new Access());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(Class<?> listener, @Nullable Object instance) {
        for (Method method : listener.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(EventListener.class)) continue;
            if (!method.canAccess(instance)) {
                LOGGER.warn("Event listener %s must be static", listener);
                continue;
            }
            if (method.getParameterCount() != 1) {
                LOGGER.warn("Event listener %s must have one parameter", listener);
                continue;
            }
            Class<?> eventType = method.getParameters()[0].getType();
            if (!Event.class.isAssignableFrom(eventType)) {
                LOGGER.warn("Event listener %s must have event parameter", listener);
                continue;
            }
            Map<Class<?>, List<EventBinding>> map = this.listeners;
            synchronized (map) {
                List bindings = this.listeners.computeIfAbsent(eventType, k -> new ArrayList());
                bindings.add(new EventBinding(eventType, listener, method.getAnnotation(EventListener.class).priority(), instance, method));
                bindings.sort(Comparator.comparing(e -> e.priority).reversed());
            }
        }
    }

    public void register(Object listener) {
        this.register(listener.getClass(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Event> T postEvent(T event) {
        Map<Class<?>, List<EventBinding>> map = this.listeners;
        synchronized (map) {
            List<EventBinding> bindings = this.listeners.get(event.getClass());
            if (bindings != null) {
                for (int i = 0; i < bindings.size(); ++i) {
                    EventBinding binding = bindings.get(i);
                    try {
                        this.modManager.setActiveModByClassloader(binding.listenerClass.getClassLoader());
                        binding.execute(event);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        LOGGER.error("Failed to deliver event", (Throwable)e);
                    }
                    if (!binding.isInvalid()) continue;
                    this.staleListeners.add(binding);
                }
            }
            this.modManager.setActiveModByClassloader(null);
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStaleRefs() {
        Map<Class<?>, List<EventBinding>> map = this.listeners;
        synchronized (map) {
            for (EventBinding binding : this.staleListeners) {
                this.listeners.get(binding.eventClass).remove(binding);
            }
            this.staleListeners.clear();
        }
    }

    public class Access {
        private Access() {
        }

        public void initialize(ModManager mods) {
            EventManager.this.modManager = mods;
            LOGGER.info("Scanning for event consumers...");
            ConfigurationBuilder config = new ConfigurationBuilder().addClassLoaders(new ClassLoader[]{this.getClass().getClassLoader()}).addUrls(ClasspathHelper.forPackage((String)"legend", (ClassLoader[])new ClassLoader[0]));
            Reflections reflections = new Reflections((Configuration)mods.addModsToReflectionsConfig(config));
            Set listeners = reflections.getTypesAnnotatedWith(EventListener.class);
            for (Class clazz : listeners) {
                EventManager.this.register(clazz, null);
            }
            for (Map.Entry entry : EventManager.this.listeners.entrySet()) {
                ((List)entry.getValue()).sort(Comparator.comparing(e -> e.priority).reversed());
            }
        }

        public void reset() {
            EventManager.this.listeners.clear();
            EventManager.this.staleListeners.clear();
        }
    }
}

