/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader;

import java.net.URL;
import java.util.Locale;
import javax.annotation.Nullable;
import org.legendofdragoon.modloader.ModState;

public class ModContainer {
    public final String modId;
    public final Object mod;
    public final ClassLoader classLoader;
    ModState state = ModState.INITIALIZED;
    private static ModContainer activeMod;

    public ModContainer(String modId, Object mod) {
        this.modId = modId;
        this.mod = mod;
        this.classLoader = mod.getClass().getClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public URL getResource(String path) {
        return this.classLoader.getResource(this.modId + "/" + path);
    }

    public URL getLangResource(Locale locale) {
        URL specific = this.getResource("lang/%s.lang".formatted(locale));
        if (specific != null) {
            return specific;
        }
        URL langCountry = this.getResource("lang/%s_%s.lang".formatted(locale.getLanguage(), locale.getCountry()));
        if (langCountry != null) {
            return langCountry;
        }
        URL lang = this.getResource("lang/%s.lang".formatted(locale.getLanguage()));
        if (lang != null) {
            return lang;
        }
        return this.getResource("lang/en.lang");
    }

    public static void setActiveMod(@Nullable ModContainer mod) {
        activeMod = mod;
    }

    public static ModContainer getActiveMod() {
        return activeMod;
    }
}

