/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader.i18n;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.legendofdragoon.modloader.ModContainer;
import org.legendofdragoon.modloader.ModManager;

public class LangManager {
    private static final Logger LOGGER = LogManager.getFormatterLogger(LangManager.class);
    private final Map<String, String> translations = new HashMap<String, String>();

    public LangManager(Consumer<Access> access) {
        access.accept(new Access());
    }

    public String getTranslation(String key) {
        return this.translations.getOrDefault(key, key).formatted(new Object[0]);
    }

    public String getTranslation(String key, Object ... args) {
        return this.translations.getOrDefault(key, key).formatted(args);
    }

    public class Access {
        private Access() {
        }

        public void initialize(ModManager mods, Locale locale) {
            for (ModContainer mod : mods.getLoadedMods()) {
                try {
                    URL langUrl = mod.getLangResource(locale);
                    if (langUrl == null) continue;
                    this.loadLang(langUrl);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to load %s for mod %d", (Object)locale, (Object)mod.modId);
                }
            }
        }

        public void loadLang(URL langUrl) throws IOException {
            HashMap<String, String> lang = new HashMap<String, String>();
            Properties properties = new Properties();
            properties.load(langUrl.openStream());
            for (Object key : properties.keySet()) {
                lang.put((String)key, properties.getProperty((String)key));
            }
            this.loadLang(lang);
        }

        public void loadLang(Path path) throws IOException {
            HashMap<String, String> lang = new HashMap<String, String>();
            Properties properties = new Properties();
            properties.load(Files.newInputStream(path, new OpenOption[0]));
            for (Object key : properties.keySet()) {
                lang.put((String)key, properties.getProperty((String)key));
            }
            this.loadLang(lang);
        }

        public void loadLang(Map<String, String> lang) {
            LangManager.this.translations.putAll(lang);
        }

        public Path getLangPath(Path directory, Locale locale) {
            Path specific = directory.resolve("%s.lang".formatted(locale));
            if (Files.exists(specific, new LinkOption[0])) {
                return specific;
            }
            Path langCountry = directory.resolve("%s_%s.lang".formatted(locale.getLanguage(), locale.getCountry()));
            if (Files.exists(langCountry, new LinkOption[0])) {
                return langCountry;
            }
            Path lang = directory.resolve("%s.lang".formatted(locale.getLanguage()));
            if (Files.exists(lang, new LinkOption[0])) {
                return lang;
            }
            Path fallback = directory.resolve("en.lang");
            if (Files.exists(fallback, new LinkOption[0])) {
                return fallback;
            }
            return null;
        }

        public void reset() {
            LangManager.this.translations.clear();
        }
    }
}

