/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader.registries;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.legendofdragoon.modloader.events.EventManager;
import org.legendofdragoon.modloader.events.registries.RegistryEvent;
import org.legendofdragoon.modloader.registries.MutableRegistry;
import org.legendofdragoon.modloader.registries.Registry;
import org.legendofdragoon.modloader.registries.RegistryEntry;
import org.legendofdragoon.modloader.registries.RegistryId;

public class Registries
implements Iterable<Registry<?>> {
    private final EventManager events;
    private final Map<RegistryId, MutableRegistry<?>> registries = new LinkedHashMap();
    private final Map<MutableRegistry<?>, Function<MutableRegistry<?>, RegistryEvent.Register<?>>> registryEvents = new HashMap();

    protected Registries(EventManager events, Consumer<Access> access) {
        this.events = events;
        access.accept(new Access());
    }

    protected <Type extends RegistryEntry> Registry<Type> addRegistry(Registry<Type> registry, Function<MutableRegistry<Type>, RegistryEvent.Register<Type>> registryEvent) {
        MutableRegistry mutableRegistry = (MutableRegistry)registry;
        this.registries.put(mutableRegistry.id, mutableRegistry);
        this.registryEvents.put(mutableRegistry, registryEvent);
        return registry;
    }

    public <T extends RegistryEntry> Registry<T> get(RegistryId id) {
        return this.registries.get(id);
    }

    public int count() {
        return this.registries.size();
    }

    @Override
    public Iterator<Registry<?>> iterator() {
        return this.registries.values().iterator();
    }

    public class Access {
        private final Set<Registry<?>> initialized = new HashSet();

        private Access() {
        }

        public void initialize(Registry<?> registry) {
            if (this.initialized.contains(registry)) {
                throw new IllegalStateException("Registry " + String.valueOf(registry) + " already initialized");
            }
            MutableRegistry mutableRegistry = (MutableRegistry)registry;
            if (!Registries.this.registryEvents.containsKey(mutableRegistry)) {
                throw new IllegalArgumentException("Unknown registry " + String.valueOf(registry));
            }
            Registries.this.events.postEvent(Registries.this.registryEvents.get(mutableRegistry).apply(mutableRegistry));
            mutableRegistry.lock();
            this.initialized.add(mutableRegistry);
        }

        public void initializeRemaining() {
            for (MutableRegistry<?> registry : Registries.this.registries.values()) {
                if (this.initialized.contains(registry)) continue;
                this.initialize(registry);
            }
        }

        public void reset() {
            this.initialized.clear();
            for (MutableRegistry<?> registry : Registries.this.registries.values()) {
                registry.reset();
            }
        }
    }
}

