/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.modloader.registries;

import java.util.Objects;
import java.util.regex.Pattern;

public final class RegistryId {
    private static final Pattern ID_PATTERN = Pattern.compile("[a-z][a-z0-9_-]*");
    private final String modId;
    private final String entryId;

    public RegistryId(String modId, String entryId) {
        if (modId.length() + entryId.length() + 1 > 255) {
            throw new IllegalArgumentException("Full registry ID must be less than 255 characters");
        }
        this.modId = RegistryId.checkId(modId);
        this.entryId = RegistryId.checkId(entryId);
    }

    public RegistryId(String id) {
        if (id.length() > 255) {
            throw new IllegalArgumentException("Full registry ID must be less than 255 characters");
        }
        String[] parts = id.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid registry ID " + id);
        }
        this.modId = RegistryId.checkId(parts[0]);
        this.entryId = RegistryId.checkId(parts[1]);
    }

    private static String checkId(String id) {
        if (!ID_PATTERN.matcher(id).matches()) {
            throw new IllegalArgumentException("Registry IDs must be lowercase, at least 3 characters, start with a latter, and contain only a-z, 0-9, _, and -");
        }
        return id;
    }

    public String toString() {
        return this.modId + ":" + this.entryId;
    }

    public String modId() {
        return this.modId;
    }

    public String entryId() {
        return this.entryId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RegistryId that = (RegistryId)obj;
        return Objects.equals(this.modId, that.modId) && Objects.equals(this.entryId, that.entryId);
    }

    public int hashCode() {
        return Objects.hash(this.modId, this.entryId);
    }
}

