/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting;

public enum ParameterType {
    IMMEDIATE(0, 1),
    NEXT_IMMEDIATE(1, 2),
    STORAGE(2, 1),
    OTHER_OTHER_STORAGE(3, 1),
    OTHER_STORAGE_OFFSET(4, 1),
    GAMEVAR_1(5, 1),
    GAMEVAR_2(6, 1),
    GAMEVAR_ARRAY_1(7, 1),
    GAMEVAR_ARRAY_2(8, 1),
    INLINE_1(9, 1),
    INLINE_2(10, 1),
    INLINE_TABLE_1(11, 1),
    INLINE_TABLE_2(12, 2),
    OTHER_STORAGE(13, 1),
    GAMEVAR_3(14, 1),
    GAMEVAR_ARRAY_3(15, 1),
    GAMEVAR_ARRAY_4(16, 1),
    GAMEVAR_ARRAY_5(17, 1),
    _12(18, 1),
    INLINE_3(19, 1),
    INLINE_TABLE_3(20, 1),
    _15(21, 1),
    _16(22, 1),
    INLINE_TABLE_4(23, 2);

    public final int opcode;
    public final int width;

    public static ParameterType byOpcode(int opcode) {
        for (ParameterType op : ParameterType.values()) {
            if (op.opcode != opcode) continue;
            return op;
        }
        return IMMEDIATE;
    }

    private ParameterType(int opcode, int width) {
        this.opcode = opcode;
        this.width = width;
    }

    public boolean isInline() {
        return this == INLINE_1 || this == INLINE_2 || this == INLINE_TABLE_1 || this == INLINE_TABLE_2 || this == INLINE_3 || this == INLINE_TABLE_3 || this == INLINE_TABLE_4;
    }

    public boolean isInlineTable() {
        return this == INLINE_TABLE_1 || this == INLINE_TABLE_2 || this == INLINE_TABLE_3 || this == INLINE_TABLE_4;
    }
}

