/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public final class Patcher {
    private Patcher() {
    }

    public static String generatePatch(Path originalFile, Path modifiedFile) throws IOException {
        List<String> originalLines = Files.readAllLines(originalFile);
        List<String> modifiedLines = Files.readAllLines(modifiedFile);
        return Patcher.generatePatch(originalLines, modifiedLines);
    }

    public static String generatePatch(List<String> originalLines, List<String> modifiedLines) {
        Patch patch = DiffUtils.diff(originalLines, modifiedLines);
        List diff = UnifiedDiffUtils.generateUnifiedDiff((String)"original", (String)"modified", originalLines, (Patch)patch, (int)3);
        StringBuilder output = new StringBuilder();
        for (String line : diff) {
            output.append(line).append('\n');
        }
        return output.toString();
    }

    public static String applyPatch(Path originalFile, Path patchFile) throws IOException, PatchFailedException {
        List<String> originalLines = Files.readAllLines(originalFile);
        List<String> patchLines = Files.readAllLines(patchFile);
        return Patcher.applyPatch(originalLines, patchLines);
    }

    public static String applyPatch(List<String> originalLines, List<String> patchLines) throws PatchFailedException {
        Patch patch = UnifiedDiffUtils.parseUnifiedDiff(patchLines);
        List patched = DiffUtils.patch(originalLines, (Patch)patch);
        StringBuilder output = new StringBuilder();
        for (String line : patched) {
            output.append(line).append('\n');
        }
        return output.toString();
    }

    public static String undoPatch(Path patchedFile, Path patchFile) throws IOException {
        List<String> patchedLines = Files.readAllLines(patchedFile);
        List<String> patchLines = Files.readAllLines(patchFile);
        return Patcher.undoPatch(patchedLines, patchLines);
    }

    public static String undoPatch(List<String> patchedLines, List<String> patchLines) {
        Patch patch = UnifiedDiffUtils.parseUnifiedDiff(patchLines);
        List unpatched = DiffUtils.unpatch(patchedLines, (Patch)patch);
        StringBuilder output = new StringBuilder();
        for (String line : unpatched) {
            output.append(line).append('\n');
        }
        return output.toString();
    }
}

