/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting.tokens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.legendofdragoon.scripting.StringInfo;
import org.legendofdragoon.scripting.tokens.Entry;

public class Script {
    public final Entry[] entries;
    public final Set<Integer> entrypoints = new HashSet<Integer>();
    public final Set<Integer> branches = new HashSet<Integer>();
    public final Set<Integer> subs = new HashSet<Integer>();
    public final Set<Integer> subTables = new HashSet<Integer>();
    public final Set<Integer> reentries = new HashSet<Integer>();
    public final Set<Integer> jumpTableDests = new HashSet<Integer>();
    public final Set<StringInfo> strings = new HashSet<StringInfo>();
    public final Map<Integer, List<String>> labels = new HashMap<Integer, List<String>>();
    public final Map<String, Integer> labelUsageCount = new HashMap<String, Integer>();
    public final List<Runnable> buildStrings = new ArrayList<Runnable>();
    private int labelCount;

    public Script(int length) {
        this.entries = new Entry[length];
    }

    public String addLabel(int destAddress, String name) {
        if (this.labels.containsKey(destAddress)) {
            String existing = this.labels.get(destAddress).get(0);
            this.labelUsageCount.putIfAbsent(existing, 0);
            this.labelUsageCount.compute(existing, (label, value) -> value + 1);
            return existing;
        }
        this.labels.computeIfAbsent(destAddress, k -> new ArrayList()).add(name);
        this.labelUsageCount.putIfAbsent(name, 0);
        this.labelUsageCount.compute(name, (label, value) -> value + 1);
        ++this.labelCount;
        return name;
    }

    public String addUniqueLabel(int destAddress, String name) {
        this.labels.computeIfAbsent(destAddress, k -> new ArrayList()).add(name);
        ++this.labelCount;
        return name;
    }

    public int getLabelCount() {
        return this.labelCount;
    }
}

