/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.legendofdragoon.scripting.MathHelper;
import org.legendofdragoon.scripting.OpType;
import org.legendofdragoon.scripting.ParameterType;
import org.legendofdragoon.scripting.State;
import org.legendofdragoon.scripting.StringInfo;
import org.legendofdragoon.scripting.meta.Meta;
import org.legendofdragoon.scripting.resolution.Register;
import org.legendofdragoon.scripting.resolution.RegisterSet;
import org.legendofdragoon.scripting.resolution.ResolvedValue;
import org.legendofdragoon.scripting.resolution.ScriptRegisters;
import org.legendofdragoon.scripting.tokens.Data;
import org.legendofdragoon.scripting.tokens.Entry;
import org.legendofdragoon.scripting.tokens.Entrypoint;
import org.legendofdragoon.scripting.tokens.LodString;
import org.legendofdragoon.scripting.tokens.Op;
import org.legendofdragoon.scripting.tokens.Param;
import org.legendofdragoon.scripting.tokens.PointerTable;
import org.legendofdragoon.scripting.tokens.Script;

public class Disassembler {
    private static final Logger LOGGER = LogManager.getFormatterLogger();
    private static final Marker DISASSEMBLY = MarkerManager.getMarker((String)"DISASSEMBLY");
    private final Meta meta;
    private State state;
    public final List<Integer> extraBranches = new ArrayList<Integer>();
    public final Map<Integer, Integer> tableLengths = new HashMap<Integer, Integer>();

    public Disassembler(Meta meta) {
        this.meta = meta;
    }

    public Script disassemble(byte[] bytes) {
        this.state = new State(bytes);
        Script script = new Script(this.state.length() / 4);
        this.getEntrypoints(script);
        for (int entrypoint : script.entrypoints) {
            this.probeBranch(script, entrypoint);
        }
        for (int entryIndex = 0; entryIndex < script.entries.length; ++entryIndex) {
            Entry entry = script.entries[entryIndex];
            if (!(entry instanceof PointerTable)) continue;
            PointerTable rel = (PointerTable)entry;
            ++entryIndex;
            for (int labelIndex = 1; labelIndex < rel.labels.length; ++labelIndex) {
                if (script.entries[entryIndex] != null && !(script.entries[entryIndex] instanceof Data) || script.labels.containsKey(entryIndex * 4)) {
                    LOGGER.warn("Jump table overrun at %x", (Object)entry.address);
                    for (int toRemove = labelIndex; toRemove < rel.labels.length; ++toRemove) {
                        if (script.labelUsageCount.get(rel.labels[toRemove]) > 1) continue;
                        for (List<String> labels : script.labels.values()) {
                            labels.remove(rel.labels[toRemove]);
                        }
                    }
                    rel.labels = Arrays.copyOfRange(rel.labels, 0, labelIndex);
                    --entryIndex;
                    break;
                }
                ++entryIndex;
            }
            --entryIndex;
        }
        for (int extraBranch : this.extraBranches) {
            this.probeBranch(script, extraBranch);
        }
        script.buildStrings.forEach(Runnable::run);
        this.fillStrings(script);
        this.fillData(script);
        LOGGER.info(DISASSEMBLY, "Probing complete");
        return script;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void probeBranch(Script script, int offset) {
        if (script.branches.contains(offset)) {
            return;
        }
        LOGGER.info(DISASSEMBLY, "Probing branch %x", (Object)offset);
        script.branches.add(offset);
        ScriptRegisters registers = script.pushRegisters();
        int oldHeaderOffset = this.state.headerOffset();
        int oldCurrentOffset = this.state.currentOffset();
        this.state.jump(offset);
        block49: while (this.state.hasMore()) {
            this.state.step();
            Op op = this.parseHeader(this.state.currentOffset());
            if (op == null) break;
            this.state.advance();
            int entryOffset = this.state.headerOffset() / 4;
            script.entries[entryOffset++] = op;
            for (int i = 0; i < op.params.length; ++i) {
                ParameterType paramType = ParameterType.byOpcode(this.state.paramType());
                int[] rawValues = new int[paramType.getWidth(this.state)];
                for (int n = 0; n < paramType.getWidth(this.state); ++n) {
                    rawValues[n] = this.state.wordAt(this.state.currentOffset() + n * 4);
                }
                int paramOffset = this.state.currentOffset();
                ResolvedValue resolved = this.parseParamValue(registers, this.state, paramType);
                Param param = new Param(paramOffset, paramType, rawValues, resolved, paramType.isInline() && resolved.isPresent() ? script.addLabel(resolved.get(), "LABEL_" + script.getLabelCount()) : null);
                for (int n = 0; n < paramType.getWidth(param); ++n) {
                    script.entries[entryOffset++] = param;
                }
                if (paramType.isInline() && resolved.orElse(0) >= script.entries.length * 4) {
                    script.addWarning(op.address, "Pointer at 0x%x destination is past the end of the script, replacing with 0".formatted(paramOffset));
                    op.params[i] = new Param(paramOffset, ParameterType.IMMEDIATE, new int[]{ParameterType.IMMEDIATE.opcode << 24}, ResolvedValue.of(0), null);
                    continue;
                }
                op.params[i] = param;
                if (paramType.isInlineTable() && op.type != OpType.GOSUB_TABLE && op.type != OpType.JMP_TABLE) {
                    if (op.type == OpType.CALL && !"none".equalsIgnoreCase(this.meta.methods[op.headerParam].params[i].branch)) {
                        HashSet tableDestinations = switch (this.meta.methods[op.headerParam].params[i].branch.toLowerCase()) {
                            case "jump" -> script.jumpTableDests;
                            case "subroutine" -> script.subs;
                            case "fork_jump" -> script.forkJumps;
                            default -> {
                                LOGGER.warn("Unknown branch type %s", (Object)this.meta.methods[op.headerParam].params[i].branch);
                                yield new HashSet();
                            }
                        };
                        param.resolvedValue.ifPresent(tableAddress -> this.probeTableOfBranches(script, tableDestinations, tableAddress, op.params[0].resolvedValue));
                        continue;
                    }
                    int finalI = i;
                    param.resolvedValue.ifPresent(tableAddress -> this.handlePointerTable(script, op, finalI, tableAddress, script.buildStrings, op.params[0].resolvedValue));
                    continue;
                }
                if (op.type != OpType.CALL || !"string".equalsIgnoreCase(this.meta.methods[op.headerParam].params[i].type)) continue;
                param.resolvedValue.ifPresent(stringAddress -> script.buildStrings.add(() -> script.strings.add(new StringInfo(stringAddress, -1))));
            }
            switch (op.type) {
                case MOV: 
                case SWAP_BROKEN: {
                    this.copyRegister(registers, op, 1, 0);
                    break;
                }
                case MOV_0: {
                    this.setRegister(registers, op, 0, 0);
                    break;
                }
                case AND: {
                    this.mergeRegister(registers, op, 1, 0, (operand, and) -> operand & and);
                    break;
                }
                case OR: {
                    this.mergeRegister(registers, op, 1, 0, (operand, or) -> operand | or);
                    break;
                }
                case XOR: {
                    this.mergeRegister(registers, op, 1, 0, (operand, xor) -> operand ^ xor);
                    break;
                }
                case ANDOR: {
                    this.mergeRegister(registers, op, 2, 0, (operand, and) -> operand & and);
                    this.mergeRegister(registers, op, 2, 1, (operand, or) -> operand | or);
                    break;
                }
                case NOT: {
                    this.modifyRegister(registers, op, 0, value -> ~value.intValue());
                    break;
                }
                case SHL: {
                    this.mergeRegister(registers, op, 1, 0, (val, shift) -> val << shift);
                    break;
                }
                case SHR: {
                    this.mergeRegister(registers, op, 1, 0, (val, shift) -> val >> shift);
                    break;
                }
                case ADD: {
                    this.mergeRegister(registers, op, 1, 0, Integer::sum);
                    break;
                }
                case SUB: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> operand - amount);
                    break;
                }
                case SUB_REV: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> amount - operand);
                    break;
                }
                case INCR: {
                    this.modifyRegister(registers, op, 0, operand -> operand + 1);
                    break;
                }
                case DECR: {
                    this.modifyRegister(registers, op, 0, operand -> operand - 1);
                    break;
                }
                case NEG: {
                    this.modifyRegister(registers, op, 0, operand -> -operand.intValue());
                    break;
                }
                case ABS: {
                    this.modifyRegister(registers, op, 0, Math::abs);
                    break;
                }
                case MUL: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> operand * amount);
                    break;
                }
                case DIV: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> MathHelper.safeDiv(operand, amount));
                    break;
                }
                case DIV_REV: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> MathHelper.safeDiv(amount, operand));
                    break;
                }
                case MOD: 
                case MOD43: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> amount != 0 ? operand % amount : 0);
                    break;
                }
                case MOD_REV: 
                case MOD_REV44: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> operand != 0 ? amount % operand : 0);
                    break;
                }
                case MUL_12: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> (operand >> 4) * (amount >> 4) >> 4);
                    break;
                }
                case DIV_12: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> (operand << 4) / amount << 8);
                    break;
                }
                case DIV_12_REV: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> (amount << 4) / operand << 8);
                    break;
                }
                case SQRT: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> (int)Math.sqrt(amount.intValue()));
                    break;
                }
                case RAND: {
                    this.setRegister(registers, op, 1, register -> op.params[0].resolvedValue.ifPresentOrElse(value -> register.range(0, value), register::unknown));
                    break;
                }
                case SIN_12: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> (short)(Math.sin(MathHelper.psxDegToRad(amount)) * 4096.0));
                    break;
                }
                case COS_12: {
                    this.mergeRegister(registers, op, 1, 0, (operand, amount) -> (short)(Math.cos(MathHelper.psxDegToRad(amount)) * 4096.0));
                    break;
                }
                case ATAN2_12: {
                    this.setRegister(registers, op, 2, dest -> op.params[0].resolvedValue.ifPresentOrElse(reg0 -> op.params[1].resolvedValue.ifPresentOrElse(reg1 -> dest.known(MathHelper.radToPsxDeg(MathHelper.atan2(reg0, reg1))), dest::unknown), dest::unknown));
                    break;
                }
                case CALL: {
                    Meta.ScriptMethod method = this.meta.methods[op.headerParam];
                    if (this.meta.methods[op.headerParam].params.length != op.params.length) {
                        // empty if block
                    }
                    for (int i = 0; i < this.meta.methods[op.headerParam].params.length; ++i) {
                        Meta.ScriptParam param = method.params[i];
                        if ("none".equalsIgnoreCase(param.branch)) continue;
                        op.params[i].resolvedValue.ifPresentOrElse(offset1 -> {
                            if ("gosub".equalsIgnoreCase(param.branch)) {
                                script.subs.add(offset1);
                            } else if ("fork_jump".equalsIgnoreCase(param.branch)) {
                                script.forkJumps.add(offset1);
                            }
                            this.probeBranch(script, offset1);
                        }, () -> LOGGER.warn("Skipping CALL at %x due to unknowable parameter", (Object)this.state.headerOffset()));
                    }
                    break;
                }
                case JMP: {
                    op.params[0].resolvedValue.ifPresentOrElse(offset1 -> this.probeBranch(script, offset1), () -> LOGGER.warn("Skipping JUMP at %x due to unknowable parameter", (Object)this.state.headerOffset()));
                    if (!op.params[0].resolvedValue.isPresent()) break;
                    break block49;
                }
                case JMP_CMP: 
                case JMP_CMP_0: {
                    op.params[op.params.length - 1].resolvedValue.ifPresentOrElse(addr -> {
                        this.probeBranch(script, this.state.currentOffset());
                        this.probeBranch(script, addr);
                    }, () -> LOGGER.warn("Skipping %s at %x due to unknowable parameter", (Object)op.type, (Object)this.state.headerOffset()));
                    break block49;
                }
                case JMP_TABLE: {
                    op.params[1].resolvedValue.ifPresentOrElse(tableOffset -> {
                        if (tableOffset != 0) {
                            if (op.params[1].type.isInlineTable()) {
                                this.probeTableOfTables(script, script.jumpTableDests, tableOffset, op.params[0].resolvedValue);
                            } else {
                                this.probeTableOfBranches(script, script.jumpTableDests, tableOffset, op.params[0].resolvedValue);
                            }
                        }
                    }, () -> LOGGER.warn("Skipping JMP_TABLE at %x due to unknowable parameter", (Object)this.state.headerOffset()));
                    break block49;
                }
                case GOSUB: {
                    op.params[0].resolvedValue.ifPresentOrElse(offset1 -> {
                        script.subs.add(offset1);
                        this.probeBranch(script, offset1);
                    }, () -> LOGGER.warn("Skipping GOSUB at %x due to unknowable parameter", (Object)this.state.headerOffset()));
                    registers.getDecompState().clear();
                    break;
                }
                case GOSUB_TABLE: {
                    op.params[1].resolvedValue.ifPresentOrElse(tableOffset -> {
                        if (tableOffset != 0) {
                            if (op.params[1].type.isInlineTable()) {
                                this.probeTableOfTables(script, script.subs, tableOffset, op.params[0].resolvedValue);
                            } else {
                                this.probeTableOfBranches(script, script.subs, tableOffset, op.params[0].resolvedValue);
                            }
                        }
                    }, () -> LOGGER.warn("Skipping GOSUB_TABLE at %x due to unknowable parameter", (Object)this.state.headerOffset()));
                    registers.getDecompState().clear();
                    break;
                }
                case REWIND: 
                case RETURN: 
                case DEALLOCATE: 
                case DEALLOCATE82: 
                case CONSUME: {
                    break block49;
                }
                case FORK: {
                    op.params[1].resolvedValue.ifPresentOrElse(offset1 -> {
                        script.forkJumps.add(offset1);
                        this.probeBranch(script, offset1);
                    }, () -> LOGGER.warn("Skipping FORK at %x due to unknowable parameter", (Object)this.state.headerOffset()));
                }
            }
        }
        script.popRegisters();
        this.state.headerOffset(oldHeaderOffset);
        this.state.currentOffset(oldCurrentOffset);
    }

    private void probeTableOfTables(Script script, Set<Integer> tableDestinations, int tableAddress, ResolvedValue length) {
        this.probeTable(script, script.subTables, tableDestinations, tableAddress, subtableAddress -> !this.isProbablyOp(script, (int)subtableAddress), subtableAddress -> this.probeTableOfBranches(script, tableDestinations, (int)subtableAddress, ResolvedValue.unresolved()), length);
    }

    private void probeTableOfBranches(Script script, Set<Integer> tableDestinations, int subtableAddress, ResolvedValue length) {
        this.probeTable(script, script.subTables, tableDestinations, subtableAddress, this::isValidOp, branchAddress -> this.probeBranch(script, (int)branchAddress), length);
    }

    private void probeTable(Script script, Set<Integer> tables, Set<Integer> tableDestinations, int tableAddress, Predicate<Integer> destinationAddressHeuristic, Consumer<Integer> visitor, ResolvedValue length) {
        int destAddress;
        if (tables.contains(tableAddress)) {
            return;
        }
        tables.add(tableAddress);
        LengthPredicate lengthPredicate = this.tableLengths.containsKey(tableAddress) ? (entryIndex, entryAddress, earliestDestination, latestDestination) -> entryIndex < this.tableLengths.get(tableAddress) : (length.isRange() ? (entryIndex, entryAddress, earliestDestination, latestDestination) -> entryIndex < length.max() : (entryIndex, entryAddress, earliestDestination, latestDestination) -> this.state.wordAt(entryAddress) > 0 ? entryAddress < earliestDestination : entryAddress > latestDestination);
        int earliestDestination2 = this.state.length();
        int latestDestination2 = 0;
        ArrayList<Integer> destinations = new ArrayList<Integer>();
        ArrayList<String> labels = new ArrayList<String>();
        int entryAddress2 = tableAddress;
        int entryIndex2 = 0;
        while (entryAddress2 <= this.state.length() - 4 && script.entries[entryAddress2 / 4] == null && lengthPredicate.get(entryIndex2, entryAddress2, earliestDestination2, latestDestination2) && (!this.isProbablyOp(script, entryAddress2) || this.isValidOp(tableAddress + this.state.wordAt(entryAddress2) * 4)) && (destAddress = tableAddress + this.state.wordAt(entryAddress2) * 4) >= 4 && destAddress <= this.state.length() - 4 && destinationAddressHeuristic.test(destAddress)) {
            if (earliestDestination2 > destAddress) {
                earliestDestination2 = destAddress;
            }
            if (latestDestination2 < destAddress) {
                latestDestination2 = destAddress;
            }
            tableDestinations.add(destAddress);
            destinations.add(destAddress);
            labels.add(script.addLabel(destAddress, "JMP_%x_%d".formatted(tableAddress, labels.size())));
            entryAddress2 += 4;
            ++entryIndex2;
        }
        if (labels.isEmpty()) {
            throw new RuntimeException("Empty table at 0x%x".formatted(tableAddress));
        }
        script.entries[tableAddress / 4] = new PointerTable(tableAddress, (String[])labels.toArray(String[]::new));
        destinations.stream().distinct().sorted(Comparator.reverseOrder()).forEach(visitor);
    }

    private void handlePointerTable(Script script, Op op, int paramIndex, int tableAddress, List<Runnable> buildStrings, ResolvedValue length) {
        if (tableAddress / 4 >= script.entries.length) {
            LOGGER.warn("Op %s param %d points to invalid pointer table 0x%x", (Object)op, (Object)paramIndex, (Object)tableAddress);
            return;
        }
        if (script.entries[tableAddress / 4] != null) {
            return;
        }
        ArrayList<Integer> destinations = new ArrayList<Integer>();
        int entryCount = 0;
        int earliestDestination = this.state.length();
        int latestDestination = 0;
        int entryAddress = tableAddress;
        int entryIndex = 0;
        while (entryAddress <= this.state.length() - 4 && script.entries[entryAddress / 4] == null && (length.isRange() ? entryIndex < length.max() : (this.state.wordAt(entryAddress) > 0 ? entryAddress < earliestDestination : entryAddress > latestDestination))) {
            int destination = tableAddress + this.state.wordAt(entryAddress) * 4;
            if (op.type == OpType.CALL && "string".equalsIgnoreCase(this.meta.methods[op.headerParam].params[paramIndex].type)) {
                if (script.entries[entryAddress / 4] instanceof Op) break;
                if (this.isProbablyOp(script, entryAddress)) {
                    boolean foundTerminator = false;
                    for (int i = destination / 4; i < destination / 4 + 300 && i < script.entries.length && script.entries[i] == null; ++i) {
                        int word = this.state.wordAt(i * 4);
                        if ((word & 0xFFFF) != 41215 && (word >> 16 & 0xFFFF) != 41215) continue;
                        foundTerminator = true;
                        break;
                    }
                    if (!foundTerminator) {
                        break;
                    }
                }
            } else if (this.isProbablyOp(script, entryAddress)) break;
            if (destination >= this.state.length() - 4) break;
            if (earliestDestination > destination) {
                earliestDestination = destination;
            }
            if (latestDestination < destination) {
                latestDestination = destination;
            }
            if (op.type == OpType.GOSUB_TABLE || op.type == OpType.JMP_TABLE) {
                destination = tableAddress + this.state.wordAt(destination) * 4;
            }
            destinations.add(destination);
            ++entryCount;
            entryAddress += 4;
            ++entryIndex;
        }
        String[] labels = new String[entryCount];
        for (entryIndex = 0; entryIndex < entryCount; ++entryIndex) {
            labels[entryIndex] = script.addLabel((Integer)destinations.get(entryIndex), "PTR_%x_%d".formatted(tableAddress, entryIndex));
        }
        PointerTable table = new PointerTable(tableAddress, labels);
        script.entries[tableAddress / 4] = table;
        if (op.type == OpType.CALL && "string".equalsIgnoreCase(this.meta.methods[op.headerParam].params[paramIndex].type)) {
            buildStrings.add(() -> {
                while (destinations.size() > table.labels.length) {
                    destinations.removeLast();
                }
                List sorted = destinations.stream().distinct().sorted(Integer::compareTo).toList();
                for (int i = 0; i < sorted.size(); ++i) {
                    if (i < sorted.size() - 1) {
                        script.strings.add(new StringInfo((Integer)sorted.get(i), (Integer)sorted.get(i + 1) - (Integer)sorted.get(i)));
                        continue;
                    }
                    script.strings.add(new StringInfo((Integer)sorted.get(i), -1));
                }
            });
        }
    }

    private void fillStrings(Script script) {
        for (StringInfo string : script.strings) {
            this.fillString(script, string.start, string.maxLength);
        }
    }

    private void fillString(Script script, int address, int maxLength) {
        int chr;
        ArrayList<Integer> chars = new ArrayList<Integer>();
        for (int i = 0; i < (maxLength != -1 ? maxLength : script.entries.length * 4 - address) && (chr = this.state.wordAt(address + i / 2 * 4) >>> i % 2 * 16 & 0xFFFF) != 41215; ++i) {
            chars.add(chr);
        }
        LodString string = new LodString(address, chars.stream().mapToInt(Integer::intValue).toArray());
        for (int i = 0; i < Math.max(1, string.chars.length / 2); ++i) {
            script.entries[address / 4 + i] = string;
        }
    }

    private void fillData(Script script) {
        for (int i = 0; i < script.entries.length; ++i) {
            if (script.entries[i] != null) continue;
            script.entries[i] = new Data(i * 4, this.state.wordAt(i * 4));
        }
    }

    private void getEntrypoints(Script script) {
        int entrypoint;
        for (int i = 0; i < 32 && this.state.hasMore() && this.isValidOp(entrypoint = this.state.currentWord()); ++i) {
            String label = "ENTRYPOINT_" + i;
            script.entries[i] = new Entrypoint(i * 4, label);
            script.entrypoints.add(entrypoint);
            script.allEntrypoints.add(entrypoint);
            script.addUniqueLabel(entrypoint, label);
            this.state.advance();
        }
    }

    private Op parseHeader(int offset) {
        if (offset > this.state.length() - 4) {
            return null;
        }
        int opcode = this.state.wordAt(offset);
        OpType type = OpType.byOpcode(opcode & 0xFF);
        if (type == null) {
            return null;
        }
        if (type == OpType.CALL && opcode >>> 16 >= 1024) {
            return null;
        }
        int paramCount = opcode >> 8 & 0xFF;
        if (type != OpType.CALL && type.params.length != paramCount) {
            return null;
        }
        int opParam = opcode >> 16;
        if (type.headerParamName == null && opParam != 0) {
            return null;
        }
        return new Op(offset, type, opParam, paramCount);
    }

    private boolean isValidOp(int offset) {
        if ((offset & 3) != 0) {
            return false;
        }
        if (offset < 4 || offset >= this.state.length()) {
            return false;
        }
        return this.parseHeader(offset) != null;
    }

    private boolean isProbablyOp(Script script, int address) {
        if ((address & 3) != 0) {
            return false;
        }
        if (address < 4 || address >= this.state.length()) {
            return false;
        }
        if (script.entries[address / 4] instanceof Op) {
            return true;
        }
        int testCount = 3;
        int certainty = 0;
        for (int opIndex = 0; opIndex < 3; ++opIndex) {
            Op op = this.parseHeader(address);
            if (op == null) {
                certainty -= 3 - opIndex;
                break;
            }
            certainty += opIndex + 1;
            address += 4;
            for (int paramIndex = 0; paramIndex < op.type.params.length; ++paramIndex) {
                ParameterType parameterType = ParameterType.byOpcode(this.state.wordAt(address) >>> 24);
                if (parameterType != ParameterType.IMMEDIATE) {
                    ++certainty;
                }
                address += parameterType.getWidth((String)null) * 4;
            }
        }
        return certainty >= 2;
    }

    private ResolvedValue parseParamValue(ScriptRegisters registers, State state, ParameterType param) {
        ResolvedValue value = switch (param) {
            case ParameterType.IMMEDIATE -> ResolvedValue.of(state.currentWord());
            case ParameterType.NEXT_IMMEDIATE -> ResolvedValue.of(state.wordAt(state.currentOffset() + 4));
            case ParameterType.STORAGE -> ResolvedValue.register(registers.getDecompState().stor[state.wordAt(state.currentOffset()) & 0xFF]);
            case ParameterType.INLINE_1, ParameterType.INLINE_2, ParameterType.INLINE_TABLE_1, ParameterType.INLINE_TABLE_3 -> ResolvedValue.of(state.headerOffset() + (short)state.currentWord() * 4);
            case ParameterType.INLINE_TABLE_2, ParameterType.INLINE_TABLE_4 -> ResolvedValue.of(state.headerOffset() + 4);
            case ParameterType.INLINE_3 -> ResolvedValue.of(state.headerOffset() + ((short)state.currentWord() + state.param2()) * 4);
            default -> ResolvedValue.unresolved();
        };
        this.state.advance(param.getWidth(state));
        return value;
    }

    private RegisterSet getRegisterSetFromStor(ScriptRegisters registers, RegisterSet sourceSet, int storIndex) {
        if (storIndex == 0) {
            return sourceSet;
        }
        Register stor = sourceSet.stor[storIndex];
        return stor.known().stream().mapToObj(registers::getState).findFirst().orElse(null);
    }

    private Register getOtherOtherStor(ScriptRegisters registers, int firstRegister, int secondRegister, int thirdRegister) {
        RegisterSet otherOtherState;
        RegisterSet otherState = this.getRegisterSetFromStor(registers, registers.getDecompState(), firstRegister);
        if (otherState != null && (otherOtherState = this.getRegisterSetFromStor(registers, otherState, secondRegister)) != null) {
            return otherOtherState.stor[thirdRegister];
        }
        return null;
    }

    private Register getOtherStorOffset(ScriptRegisters registers, int firstRegister, int secondRegister, int registerOffset) {
        RegisterSet otherState;
        Register second = registers.getDecompState().stor[secondRegister];
        if (second.isKnown() && (otherState = this.getRegisterSetFromStor(registers, registers.getDecompState(), firstRegister)) != null) {
            return otherState.stor[registerOffset + second.known().getAsInt()];
        }
        return null;
    }

    private Register getOtherStor(ScriptRegisters registers, int firstRegister, int secondRegister) {
        RegisterSet otherState = this.getRegisterSetFromStor(registers, registers.getDecompState(), firstRegister);
        if (otherState != null) {
            return otherState.stor[secondRegister];
        }
        return null;
    }

    private void setRegister(ScriptRegisters registers, Op op, int destParamIndex, Consumer<Register> setter) {
        switch (op.params[destParamIndex].type) {
            case STORAGE: {
                setter.accept(registers.getDecompState().stor[op.params[destParamIndex].rawValues[0] & 0xFF]);
            }
        }
    }

    private void setRegister(ScriptRegisters registers, Op op, int destParamIndex, int value) {
        this.setRegister(registers, op, destParamIndex, register -> register.known(value));
    }

    private void copyRegister(ScriptRegisters registers, Op op, int destParamIndex, int sourceParamIndex) {
        this.setRegister(registers, op, destParamIndex, register -> op.params[sourceParamIndex].resolvedValue.ifPresentOrElse(register::known, register::unknown));
    }

    private void modifyRegister(ScriptRegisters registers, Op op, int paramIndex, ToIntFunction<Integer> merge) {
        this.setRegister(registers, op, paramIndex, dest -> dest.known().ifPresent(merge::applyAsInt));
    }

    private void mergeRegister(ScriptRegisters registers, Op op, int destParamIndex, int sourceParamIndex, ToIntBiFunction<Integer, Integer> merge) {
        op.params[sourceParamIndex].resolvedValue.ifPresent(sourceValue -> this.setRegister(registers, op, destParamIndex, dest -> dest.known().ifPresent(destValue -> merge.applyAsInt(sourceValue, destValue))));
    }

    private static interface LengthPredicate {
        public boolean get(int var1, int var2, int var3, int var4);
    }
}

