/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting;

import java.util.function.ToIntFunction;
import org.legendofdragoon.scripting.State;
import org.legendofdragoon.scripting.tokens.Param;

public enum ParameterType {
    IMMEDIATE(0, 1),
    NEXT_IMMEDIATE(1, 2),
    STORAGE(2, 1),
    OTHER_OTHER_STORAGE(3, 1),
    OTHER_STORAGE_OFFSET(4, 1),
    GAMEVAR_1(5, 1),
    GAMEVAR_2(6, 1),
    GAMEVAR_ARRAY_1(7, 1),
    GAMEVAR_ARRAY_2(8, 1),
    INLINE_1(9, 1),
    INLINE_2(10, 1),
    INLINE_TABLE_1(11, 1),
    INLINE_TABLE_2(12, 2),
    OTHER_STORAGE(13, 1),
    GAMEVAR_3(14, 1),
    GAMEVAR_ARRAY_3(15, 1),
    GAMEVAR_ARRAY_4(16, 1),
    GAMEVAR_ARRAY_5(17, 1),
    _12(18, 1),
    INLINE_3(19, 1),
    INLINE_TABLE_3(20, 1),
    _15(21, 1),
    _16(22, 1),
    INLINE_TABLE_4(23, 2),
    REG(32, 1),
    ID(33, param -> 1 + (param.length() + 3) / 4, param -> 1 + ((param.rawValues[0] >>> 16 & 0xFF) + 3) / 4, state -> 1 + (state.param2() + 3) / 4);

    public final int opcode;
    private final ToIntFunction<String> stringToWidth;
    private final ToIntFunction<Param> paramToWidth;
    private final ToIntFunction<State> stateToWidth;

    public static ParameterType byOpcode(int opcode) {
        for (ParameterType op : ParameterType.values()) {
            if (op.opcode != opcode) continue;
            return op;
        }
        return IMMEDIATE;
    }

    private ParameterType(int opcode, ToIntFunction<String> stringToWidth, ToIntFunction<Param> paramToWidth, ToIntFunction<State> stateToWidth) {
        this.opcode = opcode;
        this.stringToWidth = stringToWidth;
        this.paramToWidth = paramToWidth;
        this.stateToWidth = stateToWidth;
    }

    private ParameterType(int opcode, int width) {
        this(opcode, param -> width, param -> width, state -> width);
    }

    public int getWidth(String param) {
        return this.stringToWidth.applyAsInt(param);
    }

    public int getWidth(Param param) {
        return this.paramToWidth.applyAsInt(param);
    }

    public int getWidth(State state) {
        return this.stateToWidth.applyAsInt(state);
    }

    public boolean isInline() {
        return this == INLINE_1 || this == INLINE_2 || this == INLINE_TABLE_1 || this == INLINE_TABLE_2 || this == INLINE_3 || this == INLINE_TABLE_3 || this == INLINE_TABLE_4;
    }

    public boolean isInlineTable() {
        return this == INLINE_TABLE_1 || this == INLINE_TABLE_2 || this == INLINE_TABLE_3 || this == INLINE_TABLE_4;
    }
}

