/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting.meta;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Meta {
    public final ScriptMethod[] methods;
    public final Map<String, String[]> enums;

    public Meta(ScriptMethod[] methods, Map<String, String[]> enums) {
        this.methods = methods;
        this.enums = enums;
    }

    private void loadMeta(List<String[]> descriptionsCsv, List<String[]> paramsCsv, List<String[]> enumsCsv, List<ScriptMethod> methods, List<String> enumClasses) {
        for (String[] description : descriptionsCsv) {
            ArrayList<ScriptParam> params = new ArrayList<ScriptParam>();
            for (String[] param : paramsCsv) {
                if (!param[0].equals(description[0])) continue;
                params.add(new ScriptParam(param[1], param[2], param[3], param[4], param[5]));
            }
            methods.add(new ScriptMethod(description[0], description[1], (ScriptParam[])params.toArray(ScriptParam[]::new)));
        }
        for (String[] val : enumsCsv) {
            String className = val[0];
            enumClasses.add(className);
        }
    }

    private List<String[]> loadCsvUrl(URL url) throws IOException, CsvException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        if (con.getResponseCode() != 200) {
            throw new RuntimeException("Failed to download meta " + String.valueOf(url) + ": " + con.getResponseCode() + " - " + con.getResponseMessage());
        }
        List<String[]> csv = this.loadCsv(con.getInputStream());
        con.disconnect();
        return csv;
    }

    private List<String[]> loadCsv(InputStream input) throws IOException, CsvException {
        try (CSVReader reader = new CSVReader((Reader)new InputStreamReader(input));){
            List list = reader.readAll();
            return list;
        }
    }

    public static class ScriptMethod {
        public final String name;
        public final String description;
        public final ScriptParam[] params;

        public ScriptMethod(String name, String description, ScriptParam[] params) {
            this.name = name;
            this.description = description;
            this.params = params;
        }

        public String toString() {
            return this.name + "(" + Arrays.stream(this.params).map(Object::toString).collect(Collectors.joining(", ")) + ")";
        }
    }

    public static class ScriptParam {
        public final String direction;
        public final String type;
        public final String name;
        public final String description;
        public final String branch;

        public ScriptParam(String direction, String type, String name, String description, String branch) {
            this.direction = direction;
            this.type = type;
            this.name = name;
            this.description = description;
            this.branch = branch;
        }

        public String toString() {
            return this.name;
        }
    }
}

