/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting.tokens;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.legendofdragoon.scripting.StringInfo;
import org.legendofdragoon.scripting.resolution.ScriptRegisters;
import org.legendofdragoon.scripting.tokens.Entry;

public class Script {
    private static final Logger LOGGER = LogManager.getFormatterLogger(Script.class);
    public final Entry[] entries;
    public final Set<Integer> entrypoints = new HashSet<Integer>();
    public final List<Integer> allEntrypoints = new ArrayList<Integer>();
    public final Set<Integer> branches = new HashSet<Integer>();
    public final Set<Integer> subs = new HashSet<Integer>();
    public final Set<Integer> subTables = new HashSet<Integer>();
    public final Set<Integer> forkJumps = new HashSet<Integer>();
    public final Set<Integer> jumpTableDests = new HashSet<Integer>();
    public final Map<Integer, String> warnings = new HashMap<Integer, String>();
    public final Set<StringInfo> strings = new HashSet<StringInfo>();
    public final Map<Integer, List<String>> labels = new HashMap<Integer, List<String>>();
    public final Map<String, Integer> labelUsageCount = new HashMap<String, Integer>();
    public final List<Runnable> buildStrings = new ArrayList<Runnable>();
    private int labelCount;
    private Deque<ScriptRegisters> registerStack = new LinkedList<ScriptRegisters>();

    public Script(int length) {
        this.entries = new Entry[length];
        this.registerStack.push(new ScriptRegisters());
        this.currentRegisters().allocateDecompState();
    }

    public void addWarning(int addr, String warning) {
        this.warnings.put(addr, warning);
        LOGGER.warn("WARNING @ 0x%x: %s", (Object)addr, (Object)warning);
    }

    public String addLabel(int destAddress, String name) {
        if (this.labels.containsKey(destAddress)) {
            String existing = this.labels.get(destAddress).get(0);
            this.labelUsageCount.putIfAbsent(existing, 0);
            this.labelUsageCount.compute(existing, (label, value) -> value + 1);
            return existing;
        }
        this.labels.computeIfAbsent(destAddress, k -> new ArrayList()).add(name);
        this.labelUsageCount.putIfAbsent(name, 0);
        this.labelUsageCount.compute(name, (label, value) -> value + 1);
        ++this.labelCount;
        return name;
    }

    public String addUniqueLabel(int destAddress, String name) {
        this.labels.computeIfAbsent(destAddress, k -> new ArrayList()).add(name);
        ++this.labelCount;
        return name;
    }

    public int getLabelCount() {
        return this.labelCount;
    }

    public ScriptRegisters currentRegisters() {
        return this.registerStack.peek();
    }

    public ScriptRegisters pushRegisters() {
        ScriptRegisters registers = new ScriptRegisters().copy(this.currentRegisters());
        this.registerStack.push(registers);
        return registers;
    }

    public void popRegisters() {
        this.registerStack.pop();
    }
}

