/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.legendofdragoon.scripting.DuplicateLabelException;
import org.legendofdragoon.scripting.IncludeFailedException;
import org.legendofdragoon.scripting.OpType;
import org.legendofdragoon.scripting.ParameterType;
import org.legendofdragoon.scripting.UnknownCallException;
import org.legendofdragoon.scripting.meta.Meta;
import org.legendofdragoon.scripting.resolution.ResolvedValue;
import org.legendofdragoon.scripting.tokens.Data;
import org.legendofdragoon.scripting.tokens.Entry;
import org.legendofdragoon.scripting.tokens.Entrypoint;
import org.legendofdragoon.scripting.tokens.LodString;
import org.legendofdragoon.scripting.tokens.Op;
import org.legendofdragoon.scripting.tokens.Param;
import org.legendofdragoon.scripting.tokens.PointerTable;
import org.legendofdragoon.scripting.tokens.Script;

public class Lexer {
    public static final Pattern INCLUDE_PATTERN = Pattern.compile("^#include\\s+([^;]+)\\s*;?.*$", 2);
    public static final String NUMBER_SUBPATTERN = "0x[a-f\\d]{1,8}|\\d{1,10}";
    public static final Pattern LINE_PATTERN = Pattern.compile("^\\s*?(?:[a-f0-9]+\\s+)?([a-z]\\w*?)(?:\\s+(.+))?$", 2);
    public static final Pattern NUMBER_PATTERN = Pattern.compile("^-?(?:0x[a-f\\d]{1,8}|\\d{1,10})$", 2);
    public static final Pattern LABEL_PATTERN = Pattern.compile("^(\\w+):$", 2);
    public static final Pattern LABEL_PARAM_PATTERN = Pattern.compile("^:(\\w+)$", 2);
    public static final Pattern CALL_PATTERN = Pattern.compile("^[a-z_]\\w*::[a-z_]\\w*$", 2);
    public static final Pattern STRING_PATTERN = Pattern.compile("^str\\[(.*?)]$", 2);
    public static final Pattern OPERATOR_PATTERN = Pattern.compile("^(<=|<|==|!=|>|>=|&|!&)$", 2);
    public static final Pattern STORAGE_PATTERN = Pattern.compile("^stor\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]$", 2);
    public static final Pattern OTHER_OTHER_STORAGE_PATTERN = Pattern.compile("^stor\\s*?\\[\\s*?stor\\s*?\\[\\s*?stor\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?,\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?,\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]$", 2);
    public static final Pattern OTHER_STORAGE_OFFSET_PATTERN = Pattern.compile("^stor\\s*?\\[\\s*?stor\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?,\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?\\+\\s*?stor\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?]$", 2);
    public static final Pattern GAMEVAR_1_PATTERN = Pattern.compile("^var\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]$", 2);
    public static final Pattern GAMEVAR_2_PATTERN = Pattern.compile("^var\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?\\+\\s*?stor\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?]$", 2);
    public static final Pattern GAMEVAR_ARRAY_1_PATTERN = Pattern.compile("^var\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?\\[\\s*?stor\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?]$", 2);
    public static final Pattern GAMEVAR_ARRAY_2_PATTERN = Pattern.compile("^var\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?\\+\\s*?stor\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?]\\s*?\\[\\s*?stor\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?]$", 2);
    public static final Pattern INLINE_1_MATCHER = Pattern.compile("^inl\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10}|:\\w+)\\s*?]$", 2);
    public static final Pattern INLINE_2_MATCHER = Pattern.compile("^inl\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10}|:\\w+)\\s*?\\[\\s*?stor\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?]\\s*?]$", 2);
    public static final Pattern GAMEVAR_3_PATTERN = Pattern.compile("^var\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?\\+\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]$");
    public static final Pattern INLINE_3_MATCHER = Pattern.compile("^inl\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10}|:\\w+)\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10}|:\\w+)\\s*?\\[\\s*?stor\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?]\\s*?]\\s*?]$", 2);
    public static final Pattern CONTROL_PATTERN = Pattern.compile("^<\\s*?([a-z]+)(?:\\s*?=\\s*?(0x[a-f\\d]{1,8}|\\d{1,10}))?\\s*?>$", 2);
    public static final Pattern GAMEVAR_ARRAY_3_PATTERN = Pattern.compile("^var\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]$", 2);
    public static final Pattern GAMEVAR_ARRAY_4_PATTERN = Pattern.compile("^var\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?\\s*?\\+\\s*?stor\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?]\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]$", 2);
    public static final Pattern INLINE_6_PATTERN = Pattern.compile("^inl\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10}|:\\w+)\\s*?\\+\\s*?inl\\s*?\\[(0x[a-f\\d]{1,8}|\\d{1,10}|:\\w+)\\s*?\\+\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?]$", 2);
    public static final Pattern REG_PATTERN = Pattern.compile("^reg\\s*?\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]$", 2);
    public static final Pattern REG_VAR_PATTERN = Pattern.compile("^reg\\s*?\\[\\s*?stor\\[\\s*?(0x[a-f\\d]{1,8}|\\d{1,10})\\s*?]\\s*?]$", 2);
    public static final Pattern ID_PATTERN = Pattern.compile("^id\\s*?\\[\\s*?(.*?:.*?)\\s*?]$", 2);
    private final Meta meta;

    public Lexer(Meta meta) {
        this.meta = meta;
    }

    public Script lex(Path path, String source) {
        List<String> lines = this.splitSource(source);
        ArrayList<Entry> entries = new ArrayList<Entry>();
        HashMap<String, Integer> labels = new HashMap<String, Integer>();
        HashSet<String> tables = new HashSet<String>();
        for (int lineIndex = 0; lineIndex < lines.size(); ++lineIndex) {
            Matcher labelMatcher;
            String line = lines.get(lineIndex);
            int address = entries.size() * 4;
            Param[] includeMatcher = INCLUDE_PATTERN.matcher(line);
            if (includeMatcher.matches()) {
                Path includePath = Path.of(includeMatcher.group(1), new String[0]);
                if (!includePath.isAbsolute()) {
                    includePath = path.getParent().resolve(includePath);
                }
                ArrayList<String> newLines = new ArrayList<String>(lines.subList(0, lineIndex));
                try {
                    newLines.addAll(this.splitSource(Files.readString(includePath)));
                }
                catch (IOException e2) {
                    throw new IncludeFailedException("Include for " + String.valueOf(includePath) + " failed", e2);
                }
                newLines.addAll(lines.subList(lineIndex + 1, lines.size()));
                lines = newLines;
                line = lines.get(lineIndex);
            }
            if ((labelMatcher = LABEL_PATTERN.matcher(line)).matches()) {
                String label = labelMatcher.group(1);
                if (labels.containsKey(label)) {
                    throw new DuplicateLabelException("Label %s already defined at address 0x%x".formatted(label, labels.get(label)));
                }
                labels.put(label, address);
                continue;
            }
            Entry entry = this.lexLine(address, line);
            entries.add(entry);
            if (entry instanceof Op) {
                Op op = (Op)entry;
                if (op.type == OpType.GOSUB_TABLE || op.type == OpType.JMP_TABLE && op.params[1].label != null) {
                    tables.add(op.params[1].label);
                }
                for (Param param : op.params) {
                    if (param.type.isInlineTable() && param.label != null) {
                        tables.add(param.label);
                    }
                    for (int i = 0; i < param.type.getWidth(param); ++i) {
                        entries.add(param);
                    }
                }
                continue;
            }
            if (!(entry instanceof LodString)) continue;
            LodString string = (LodString)entry;
            for (int i = 1; i < (string.chars.length + 1) / 2; ++i) {
                entries.add(entry);
            }
        }
        for (Entry entry : entries) {
            if (!(entry instanceof Op)) continue;
            Op op = (Op)entry;
            block11: for (Param param : op.params) {
                int tableOffset;
                if (param.label == null) continue;
                if (!labels.containsKey(param.label)) {
                    throw new RuntimeException("Missing label " + param.label);
                }
                int address = (Integer)labels.get(param.label);
                switch (param.type) {
                    case INLINE_1: 
                    case INLINE_2: 
                    case INLINE_TABLE_1: 
                    case INLINE_TABLE_3: {
                        param.rawValues[0] = param.rawValues[0] | (address - op.address) / 4 & 0xFFFF;
                        break;
                    }
                    case INLINE_TABLE_2: 
                    case INLINE_3: 
                    case INLINE_TABLE_4: {
                        throw new RuntimeException("Need to implement label bindings for " + String.valueOf((Object)param.type));
                    }
                }
                if (op.type != OpType.GOSUB_TABLE && op.type != OpType.JMP_TABLE || !param.type.isInlineTable()) continue;
                for (int entryOffset = tableOffset = (Integer)labels.get(param.label) / 4; entryOffset < entries.size(); ++entryOffset) {
                    Object e3;
                    int finalEntryOffset = entryOffset;
                    if (entryOffset != tableOffset) {
                        if (labels.entrySet().stream().filter(e -> (Integer)e.getValue() == finalEntryOffset * 4).map(Map.Entry::getKey).anyMatch(tables::contains)) continue block11;
                    }
                    if (!((e3 = entries.get(entryOffset)) instanceof PointerTable)) continue block11;
                    PointerTable table = (PointerTable)e3;
                    tables.add(table.labels[0]);
                }
            }
        }
        List<Integer> tableOffsets = tables.stream().map(key -> (Integer)labels.get(key) / 4).distinct().sorted(Comparator.reverseOrder()).toList();
        int maxOffset = entries.size();
        for (int tableOffset : tableOffsets) {
            Object e4;
            ArrayList<String> newLabels = new ArrayList<String>();
            for (int offset = tableOffset; offset < maxOffset && (e4 = entries.get(offset)) instanceof PointerTable; ++offset) {
                PointerTable table = (PointerTable)e4;
                newLabels.add(table.labels[0]);
            }
            entries.set(tableOffset, new PointerTable(tableOffset * 4, 0, (String[])newLabels.toArray(String[]::new)));
            for (int i = 1; i < newLabels.size(); ++i) {
                entries.set(tableOffset + i, new Data((tableOffset + i) * 4, 0));
            }
            maxOffset = tableOffset;
        }
        Script script = new Script(entries.size());
        entries.toArray(script.entries);
        for (Map.Entry entry : labels.entrySet()) {
            script.labels.computeIfAbsent((Integer)entry.getValue(), k -> new ArrayList()).add((String)entry.getKey());
        }
        return script;
    }

    private List<String> splitSource(String source) {
        return source.lines().map(this::removeComment).map(String::strip).filter(Predicate.not(String::isBlank)).toList();
    }

    private String removeComment(String line) {
        int pos = line.indexOf(59);
        if (pos == -1) {
            return line;
        }
        return line.substring(0, pos);
    }

    private Entry lexLine(int address, String line) {
        Matcher lineMatcher = LINE_PATTERN.matcher(line);
        if (lineMatcher.matches()) {
            String command = lineMatcher.group(1);
            String paramsStr = lineMatcher.group(2);
            try {
                if ("entrypoint".equalsIgnoreCase(command)) {
                    if (!LABEL_PARAM_PATTERN.matcher(paramsStr).matches()) {
                        throw new RuntimeException("Invalid entrypoint label " + paramsStr);
                    }
                    return new Entrypoint(address, paramsStr.substring(1));
                }
                if ("data".equalsIgnoreCase(command)) {
                    Matcher stringMatcher = STRING_PATTERN.matcher(paramsStr);
                    if (stringMatcher.matches()) {
                        return LodString.fromString(address, stringMatcher.group(1));
                    }
                    return new Data(address, this.parseInt(paramsStr));
                }
                if ("rel".equalsIgnoreCase(command)) {
                    if (!LABEL_PARAM_PATTERN.matcher(paramsStr).matches()) {
                        throw new RuntimeException("Invalid relative pointer label " + paramsStr);
                    }
                    return new PointerTable(address, 0, new String[]{paramsStr.substring(1)});
                }
                OpType opType = OpType.byName(command);
                if (opType != null) {
                    int headerParam;
                    Param[] params;
                    if (paramsStr != null) {
                        params = this.parseParams(address, address + 4, opType, paramsStr);
                        if (opType.headerParamName == null) {
                            headerParam = 0;
                        } else {
                            headerParam = params[0].rawValues[0];
                            params = Arrays.copyOfRange(params, 1, params.length);
                        }
                    } else {
                        headerParam = 0;
                        params = new Param[]{};
                    }
                    Op op = new Op(address, opType, headerParam, params.length);
                    System.arraycopy(params, 0, op.params, 0, params.length);
                    return op;
                }
            }
            catch (NumberFormatException e) {
                System.err.println(e.getMessage());
            }
        }
        throw new RuntimeException("Invalid line \"" + line + "\"");
    }

    private Param[] parseParams(int opAddress, int address, OpType opType, String paramsString) {
        String[] paramStrings = this.splitParameters(paramsString);
        Param[] params = new Param[paramStrings.length];
        int headerParam = 0;
        for (int i = 0; i < params.length; ++i) {
            Param param;
            params[i] = param = this.parseParam(opAddress, address, opType, headerParam, i - (opType.headerParamName != null ? 1 : 0), paramStrings[i]);
            if (i != 0 || opType.headerParamName == null) {
                address += param.type.getWidth(paramStrings[i]) * 4;
                continue;
            }
            headerParam = param.rawValues[0];
        }
        return params;
    }

    private Param parseParam(int opAddress, int address, OpType opType, int headerParam, int paramIndex, String paramString) {
        if (CALL_PATTERN.matcher(paramString).matches()) {
            boolean found = false;
            for (int i = 0; i < this.meta.methods.length; ++i) {
                if (!this.meta.methods[i].name.equalsIgnoreCase(paramString)) continue;
                paramString = Integer.toString(i);
                found = true;
                break;
            }
            if (!found) {
                throw new UnknownCallException("Unknown call " + paramString);
            }
        }
        try {
            int value = this.parseInt(paramString);
            if ((value & 0xFF000000) == 0) {
                return new Param(address, ParameterType.IMMEDIATE, new int[]{value}, ResolvedValue.of(value), null);
            }
            return new Param(address, ParameterType.NEXT_IMMEDIATE, new int[]{this.packParam(ParameterType.NEXT_IMMEDIATE), value}, ResolvedValue.of(value), null);
        }
        catch (NumberFormatException value) {
            String enumClass;
            Matcher matcher;
            if (paramIndex == -1 && (opType == OpType.WAIT_CMP || opType == OpType.WAIT_CMP_0 || opType == OpType.JMP_CMP || opType == OpType.JMP_CMP_0) && (matcher = OPERATOR_PATTERN.matcher(paramString)).matches()) {
                int operatorIndex = switch (matcher.group(1)) {
                    case "<=" -> 0;
                    case "<" -> 1;
                    case "==" -> 2;
                    case "!=" -> 3;
                    case ">" -> 4;
                    case ">=" -> 5;
                    case "&" -> 6;
                    case "!&" -> 7;
                    default -> throw new RuntimeException("Unknown operator " + matcher.group(1));
                };
                return new Param(address, ParameterType.IMMEDIATE, new int[]{operatorIndex}, ResolvedValue.of(operatorIndex), null);
            }
            if (paramIndex != -1 && paramIndex < this.meta.methods[headerParam].params.length && opType == OpType.CALL && this.meta.enums.containsKey(enumClass = this.meta.methods[headerParam].params[paramIndex].type)) {
                String[] enumValues = this.meta.enums.get(enumClass);
                for (int i = 0; i < enumValues.length; ++i) {
                    if (!enumValues[i].equalsIgnoreCase(paramString)) continue;
                    return new Param(address, ParameterType.IMMEDIATE, new int[]{i}, ResolvedValue.of(i), null);
                }
                throw new RuntimeException("Unknown " + enumClass + " value " + paramString);
            }
            matcher = STORAGE_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                return new Param(address, ParameterType.STORAGE, new int[]{this.packParam(ParameterType.STORAGE, p0)}, ResolvedValue.unresolved(), null);
            }
            matcher = OTHER_OTHER_STORAGE_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                int p1 = this.parseInt(matcher.group(2));
                int p2 = this.parseInt(matcher.group(3));
                return new Param(address, ParameterType.OTHER_OTHER_STORAGE, new int[]{this.packParam(ParameterType.OTHER_OTHER_STORAGE, p0, p1, p2)}, ResolvedValue.unresolved(), null);
            }
            matcher = OTHER_STORAGE_OFFSET_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                int p1 = this.parseInt(matcher.group(2));
                int p2 = this.parseInt(matcher.group(3));
                return new Param(address, ParameterType.OTHER_STORAGE_OFFSET, new int[]{this.packParam(ParameterType.OTHER_STORAGE_OFFSET, p0, p1, p2)}, ResolvedValue.unresolved(), null);
            }
            matcher = GAMEVAR_1_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                return new Param(address, ParameterType.GAMEVAR_1, new int[]{this.packParam(ParameterType.GAMEVAR_1, p0)}, ResolvedValue.unresolved(), null);
            }
            matcher = GAMEVAR_2_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                int p1 = this.parseInt(matcher.group(2));
                return new Param(address, ParameterType.GAMEVAR_2, new int[]{this.packParam(ParameterType.GAMEVAR_2, p0, p1)}, ResolvedValue.unresolved(), null);
            }
            matcher = GAMEVAR_ARRAY_1_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                int p1 = this.parseInt(matcher.group(2));
                return new Param(address, ParameterType.GAMEVAR_ARRAY_1, new int[]{this.packParam(ParameterType.GAMEVAR_ARRAY_1, p0, p1)}, ResolvedValue.unresolved(), null);
            }
            matcher = GAMEVAR_ARRAY_2_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                int p1 = this.parseInt(matcher.group(2));
                int p2 = this.parseInt(matcher.group(3));
                return new Param(address, ParameterType.GAMEVAR_ARRAY_2, new int[]{this.packParam(ParameterType.GAMEVAR_ARRAY_2, p0, p1, p2)}, ResolvedValue.unresolved(), null);
            }
            matcher = INLINE_1_MATCHER.matcher(paramString);
            if (matcher.matches()) {
                String label;
                int inline;
                String val = matcher.group(1);
                if (LABEL_PARAM_PATTERN.matcher(val).matches()) {
                    inline = this.packParam(ParameterType.INLINE_1);
                    label = val.substring(1);
                } else {
                    int value2 = this.parseInt(val);
                    int p0 = (value2 - opAddress) / 4;
                    inline = this.packParam(ParameterType.INLINE_1) | p0 & 0xFFFF;
                    label = null;
                }
                return new Param(address, ParameterType.INLINE_1, new int[]{inline}, ResolvedValue.unresolved(), label);
            }
            matcher = INLINE_2_MATCHER.matcher(paramString);
            if (matcher.matches()) {
                String label;
                int inline;
                String val = matcher.group(1);
                if (LABEL_PARAM_PATTERN.matcher(val).matches()) {
                    int p2 = this.parseInt(matcher.group(2));
                    inline = this.packParam(ParameterType.INLINE_2, 0, 0, p2);
                    label = val.substring(1);
                } else {
                    int value3 = this.parseInt(val);
                    int p0 = (value3 - opAddress) / 4;
                    int p2 = this.parseInt(matcher.group(2));
                    inline = this.packParam(ParameterType.INLINE_2, 0, 0, p2) | p0 & 0xFFFF;
                    label = null;
                }
                return new Param(address, ParameterType.INLINE_2, new int[]{inline}, ResolvedValue.unresolved(), label);
            }
            matcher = GAMEVAR_3_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                int p1 = this.parseInt(matcher.group(2));
                return new Param(address, ParameterType.GAMEVAR_3, new int[]{this.packParam(ParameterType.GAMEVAR_3, p0, p1)}, ResolvedValue.unresolved(), null);
            }
            matcher = INLINE_3_MATCHER.matcher(paramString);
            if (matcher.matches()) {
                String label;
                int inline;
                if (!matcher.group(1).equalsIgnoreCase(matcher.group(2))) {
                    throw new RuntimeException("Invalid INLINE_3 def, addresses must match (" + matcher.group(1) + "/" + matcher.group(2) + ")");
                }
                String val = matcher.group(1);
                if (LABEL_PARAM_PATTERN.matcher(val).matches()) {
                    int p2 = this.parseInt(matcher.group(3));
                    inline = this.packParam(ParameterType.INLINE_TABLE_1, 0, 0, p2);
                    label = val.substring(1);
                } else {
                    int value4 = this.parseInt(val);
                    int p0 = (value4 - opAddress) / 4;
                    int p2 = this.parseInt(matcher.group(3));
                    inline = this.packParam(ParameterType.INLINE_TABLE_1, 0, 0, p2) | p0 & 0xFFFF;
                    label = null;
                }
                return new Param(address, ParameterType.INLINE_TABLE_1, new int[]{inline}, ResolvedValue.unresolved(), label);
            }
            matcher = GAMEVAR_ARRAY_3_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                int p1 = this.parseInt(matcher.group(2));
                return new Param(address, ParameterType.GAMEVAR_ARRAY_3, new int[]{this.packParam(ParameterType.GAMEVAR_ARRAY_3, p0, p1)}, ResolvedValue.unresolved(), null);
            }
            matcher = GAMEVAR_ARRAY_4_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                int p1 = this.parseInt(matcher.group(2));
                int p2 = this.parseInt(matcher.group(3));
                return new Param(address, ParameterType.GAMEVAR_ARRAY_4, new int[]{this.packParam(ParameterType.GAMEVAR_ARRAY_4, p0, p1, p2)}, ResolvedValue.unresolved(), null);
            }
            matcher = INLINE_6_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                String label;
                int inline;
                if (!matcher.group(1).equalsIgnoreCase(matcher.group(2))) {
                    throw new RuntimeException("Invalid INLINE_6 def, addresses must match (" + matcher.group(1) + "/" + matcher.group(2) + ")");
                }
                String val = matcher.group(1);
                if (LABEL_PARAM_PATTERN.matcher(val).matches()) {
                    int p2 = this.parseInt(matcher.group(3));
                    inline = this.packParam(ParameterType.INLINE_TABLE_3, 0, 0, p2);
                    label = val.substring(1);
                } else {
                    int value5 = this.parseInt(val);
                    int p0 = (value5 - opAddress) / 4;
                    int p2 = this.parseInt(matcher.group(3));
                    inline = this.packParam(ParameterType.INLINE_TABLE_3, 0, 0, p2) | p0 & 0xFFFF;
                    label = null;
                }
                return new Param(address, ParameterType.INLINE_TABLE_3, new int[]{inline}, ResolvedValue.unresolved(), label);
            }
            matcher = ID_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                String id = matcher.group(1);
                int[] packed = new int[ParameterType.ID.getWidth(id)];
                packed[0] = ParameterType.ID.opcode << 24 | id.length() << 16;
                for (int i = 0; i < id.length(); ++i) {
                    int n = 1 + i / 4;
                    packed[n] = packed[n] | (id.charAt(i) & 0xFF) << i % 4 * 8;
                }
                return new Param(address, ParameterType.ID, packed, ResolvedValue.unresolved(), null);
            }
            matcher = REG_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                return new Param(address, ParameterType.REG, new int[]{this.packParam(ParameterType.REG, p0)}, ResolvedValue.unresolved(), null);
            }
            matcher = REG_VAR_PATTERN.matcher(paramString);
            if (matcher.matches()) {
                int p0 = this.parseInt(matcher.group(1));
                return new Param(address, ParameterType.REG_VAR, new int[]{this.packParam(ParameterType.REG_VAR, p0)}, ResolvedValue.unresolved(), null);
            }
            if ("null".equalsIgnoreCase(paramString)) {
                return new Param(address, ParameterType.REG_NULL, new int[]{this.packParam(ParameterType.REG_NULL)}, ResolvedValue.of(0), null);
            }
            throw new RuntimeException("Unknown param " + paramString);
        }
    }

    private String[] splitParameters(String parametersString) {
        ArrayList<Integer> commas = new ArrayList<Integer>();
        int bracketCount = 0;
        block10: for (int i = 0; i < parametersString.length(); ++i) {
            switch (parametersString.substring(i, i + 1)) {
                case "[": {
                    ++bracketCount;
                    continue block10;
                }
                case "]": {
                    if (--bracketCount >= 0) continue block10;
                    throw new RuntimeException("Invalid parameters " + parametersString);
                }
                case ",": {
                    if (bracketCount != 0) continue block10;
                    commas.add(i);
                }
            }
        }
        commas.add(parametersString.length());
        String[] params = new String[commas.size()];
        int start = 0;
        for (int i = 0; i < params.length; ++i) {
            params[i] = parametersString.substring(start, (Integer)commas.get(i)).strip();
            start = (Integer)commas.get(i) + 1;
        }
        return params;
    }

    private int parseInt(String val) {
        if (NUMBER_PATTERN.matcher(val).matches()) {
            if (val.startsWith("0x")) {
                return Integer.parseUnsignedInt(val.substring(2), 16);
            }
            return Integer.parseInt(val);
        }
        throw new NumberFormatException("Invalid number " + val);
    }

    private int packParam(ParameterType type, int p0, int p1, int p2) {
        return type.opcode << 24 | (p2 & 0xFF) << 16 | (p1 & 0xFF) << 8 | p0 & 0xFF;
    }

    private int packParam(ParameterType type, int p0, int p1) {
        return this.packParam(type, p0, p1, 0);
    }

    private int packParam(ParameterType type, int p0) {
        return this.packParam(type, p0, 0, 0);
    }

    private int packParam(ParameterType type) {
        return this.packParam(type, 0, 0, 0);
    }
}

