/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.legendofdragoon.scripting.meta.Meta;

public final class Patcher {
    private static final Pattern CALL_MATCHER = Pattern.compile("^call\\s+(.+?)\\s*(?:,.*|$)", 2);

    private Patcher() {
    }

    public static String generatePatch(Meta meta, Path originalFile, Path modifiedFile) throws IOException {
        List<String> originalLines = Patcher.strip(meta, Files.readAllLines(originalFile));
        List<String> modifiedLines = Patcher.strip(meta, Files.readAllLines(modifiedFile));
        return Patcher.generatePatch(originalLines, modifiedLines);
    }

    public static String generatePatch(List<String> originalLines, List<String> modifiedLines) {
        Patch patch = DiffUtils.diff(originalLines, modifiedLines);
        List diff = UnifiedDiffUtils.generateUnifiedDiff((String)"original", (String)"modified", originalLines, (Patch)patch, (int)3);
        StringBuilder output = new StringBuilder();
        for (String line : diff) {
            output.append(line).append('\n');
        }
        return output.toString();
    }

    public static String applyPatch(Path originalFile, Path patchFile) throws IOException, PatchFailedException {
        List<String> originalLines = Files.readAllLines(originalFile);
        List<String> patchLines = Files.readAllLines(patchFile);
        return Patcher.applyPatch(originalLines, patchLines);
    }

    public static String applyPatch(List<String> originalLines, List<String> patchLines) throws PatchFailedException {
        Patch patch = UnifiedDiffUtils.parseUnifiedDiff(patchLines);
        List patched = DiffUtils.patch(originalLines, (Patch)patch);
        StringBuilder output = new StringBuilder();
        for (String line : patched) {
            output.append(line).append('\n');
        }
        return output.toString();
    }

    public static String undoPatch(Path patchedFile, Path patchFile) throws IOException {
        List<String> patchedLines = Files.readAllLines(patchedFile);
        List<String> patchLines = Files.readAllLines(patchFile);
        return Patcher.undoPatch(patchedLines, patchLines);
    }

    public static String undoPatch(List<String> patchedLines, List<String> patchLines) {
        Patch patch = UnifiedDiffUtils.parseUnifiedDiff(patchLines);
        List unpatched = DiffUtils.unpatch(patchedLines, (Patch)patch);
        StringBuilder output = new StringBuilder();
        for (String line : unpatched) {
            output.append(line).append('\n');
        }
        return output.toString();
    }

    private static List<String> strip(Meta meta, List<String> input) {
        return input.stream().map(line -> line.indexOf(59) != -1 ? line.substring(0, line.indexOf(59)) : line).map(Patcher.replaceCalls(meta)).map(String::strip).filter(Predicate.not(String::isBlank)).toList();
    }

    private static Function<String, String> replaceCalls(Meta meta) {
        return line -> {
            Matcher matcher = CALL_MATCHER.matcher((CharSequence)line);
            if (matcher.matches()) {
                String call = matcher.group(1).strip();
                for (int i = 0; i < meta.methods.length; ++i) {
                    if (!meta.methods[i].name.equals(call)) continue;
                    return line.replace(call, Integer.toString(i));
                }
            }
            return line;
        };
    }
}

