/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.legendofdragoon.scripting.OpType;
import org.legendofdragoon.scripting.ParameterType;
import org.legendofdragoon.scripting.meta.Meta;
import org.legendofdragoon.scripting.tokens.Data;
import org.legendofdragoon.scripting.tokens.Entry;
import org.legendofdragoon.scripting.tokens.Entrypoint;
import org.legendofdragoon.scripting.tokens.LodString;
import org.legendofdragoon.scripting.tokens.Op;
import org.legendofdragoon.scripting.tokens.Param;
import org.legendofdragoon.scripting.tokens.PointerTable;
import org.legendofdragoon.scripting.tokens.Script;

public class Translator {
    private static final Logger LOGGER = LogManager.getFormatterLogger();
    private final Map<String, String> reindexedLabels = new HashMap<String, String>();
    public boolean stripNames;
    public boolean stripComments;
    public boolean lineNumbers;

    public String translate(Script script, Meta meta) {
        StringBuilder builder = new StringBuilder();
        List<String> sortedLabels = script.labels.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).flatMap(e -> ((List)e.getValue()).stream()).filter(label -> label.startsWith("LABEL_")).toList();
        for (int i = 0; i < sortedLabels.size(); ++i) {
            this.reindexedLabels.put(sortedLabels.get(i), "LABEL_" + i);
        }
        for (int entryIndex = 0; entryIndex < script.entries.length; ++entryIndex) {
            Entry entry = script.entries[entryIndex];
            if (!this.stripComments) {
                if (script.subs.contains(entry.address)) {
                    builder.append("\n; SUBROUTINE\n");
                }
                if (script.subTables.contains(entry.address)) {
                    builder.append("\n; SUBROUTINE TABLE\n");
                }
                if (script.forkJumps.contains(entry.address)) {
                    builder.append("\n; FORK JMP\n");
                }
                if (script.warnings.containsKey(entry.address)) {
                    builder.append("\n; WARNING: ").append(script.warnings.get(entry.address)).append('\n');
                }
            }
            if (script.labels.containsKey(entry.address)) {
                for (String label2 : script.labels.get(entry.address)) {
                    builder.append(this.getReindexedLabel(label2)).append(":\n");
                }
            }
            if (entry instanceof Entrypoint) {
                Entrypoint entrypoint = (Entrypoint)entry;
                builder.append("entrypoint :").append(entrypoint.destination).append('\n');
                continue;
            }
            if (entry instanceof Data) {
                Data data = (Data)entry;
                if (this.lineNumbers) {
                    builder.append(Integer.toHexString(data.address)).append(": ");
                }
                builder.append("data 0x%x".formatted(data.value)).append('\n');
                continue;
            }
            if (entry instanceof PointerTable) {
                PointerTable rel = (PointerTable)entry;
                if (rel.labels.length == 0) {
                    LOGGER.warn("Empty jump table @ 0x%x", (Object)rel.address);
                    builder.append("\n; WARNING: empty table\n");
                    if (this.lineNumbers) {
                        builder.append(Integer.toHexString(rel.address)).append(": ");
                    }
                    builder.append("data 0x%x".formatted(rel.originalValue)).append('\n');
                    continue;
                }
                for (int i = 0; i < rel.labels.length; ++i) {
                    builder.append("rel :").append(this.getReindexedLabel(rel.labels[i])).append('\n');
                    ++entryIndex;
                }
                --entryIndex;
                continue;
            }
            if (entry instanceof LodString) {
                LodString string = (LodString)entry;
                List<Map.Entry> overlappingLabels = script.labels.entrySet().stream().filter(e -> (Integer)e.getKey() > string.address && (Integer)e.getKey() < string.address + (string.chars.length + 2) / 2 * 4).sorted(Comparator.comparingInt(Map.Entry::getKey)).toList();
                builder.append("data str[");
                if (overlappingLabels.isEmpty()) {
                    builder.append(string);
                } else {
                    int currentIndex = 0;
                    for (Map.Entry overlappingLabel : overlappingLabels) {
                        int nextLabelIndex = ((Integer)overlappingLabel.getKey() - string.address) / 2;
                        builder.append(new LodString(0, Arrays.copyOfRange(string.chars, currentIndex, nextLabelIndex))).append("<noterm>]\n");
                        for (String label3 : (List)overlappingLabel.getValue()) {
                            builder.append(this.getReindexedLabel(label3)).append(":\n");
                        }
                        builder.append("data str[");
                        currentIndex = nextLabelIndex;
                    }
                    builder.append(new LodString(string.address + currentIndex * 2, Arrays.copyOfRange(string.chars, currentIndex, string.chars.length)));
                }
                builder.append("]\n");
                entryIndex += string.chars.length / 2;
                continue;
            }
            if (entry instanceof Op) {
                Op op = (Op)entry;
                if (this.lineNumbers) {
                    builder.append(Integer.toHexString(op.address)).append(": ");
                }
                builder.append(op.type.name);
                if (op.type == OpType.CALL) {
                    if (!this.stripNames) {
                        builder.append(' ').append(meta.methods[op.headerParam].name);
                    } else {
                        builder.append(' ').append(op.headerParam);
                    }
                } else if (op.type.headerParamName != null) {
                    builder.append(' ').append(this.buildHeaderParam(op));
                }
                if (op.type == OpType.WAIT_CMP_0 || op.type == OpType.JMP_CMP_0) {
                    builder.append(", 0x0");
                }
                if (op.type == OpType.MOV_0) {
                    builder.append(" 0x0,");
                }
                for (int paramIndex = 0; paramIndex < op.params.length; ++paramIndex) {
                    if (paramIndex != 0 || op.type.headerParamName != null) {
                        builder.append(',');
                    }
                    builder.append(' ').append(this.buildParam(meta, op, op.params[paramIndex], paramIndex));
                }
                if (!this.stripComments) {
                    if (op.type == OpType.CALL && meta.methods[op.headerParam].params.length != 0) {
                        builder.append(" ; ").append(Arrays.stream(meta.methods[op.headerParam].params).map(Object::toString).collect(Collectors.joining(", ")));
                    } else if (op.params.length != 0 || op.type.headerParamName != null) {
                        builder.append(" ; ");
                        if (op.type.headerParamName != null) {
                            builder.append(op.type.headerParamName);
                            if (op.params.length != 0) {
                                builder.append(", ");
                            }
                        }
                        builder.append(String.join((CharSequence)", ", op.type.getCommentParamNames()));
                    }
                }
                builder.append('\n');
                continue;
            }
            if (entry instanceof Param) continue;
            throw new RuntimeException("Unknown entry " + entry.getClass().getSimpleName());
        }
        return builder.toString();
    }

    private String getReindexedLabel(String label) {
        return this.reindexedLabels.getOrDefault(label, label);
    }

    private String buildHeaderParam(Op op) {
        if (op.type == OpType.WAIT_CMP || op.type == OpType.WAIT_CMP_0 || op.type == OpType.JMP_CMP || op.type == OpType.JMP_CMP_0) {
            return switch (op.headerParam) {
                case 0 -> "<=";
                case 1 -> "<";
                case 2 -> "==";
                case 3 -> "!=";
                case 4 -> ">";
                case 5 -> ">=";
                case 6 -> "&";
                case 7 -> "!&";
                default -> "Unknown CMP operator " + op.headerParam;
            };
        }
        return "0x%x".formatted(op.headerParam);
    }

    private String buildParam(Meta meta, Op op, Param param, int paramIndex) {
        if (param.label != null) {
            String label = ":" + this.getReindexedLabel(param.label);
            return switch (param.type) {
                case ParameterType.INLINE_2 -> "inl[%s[stor[%d]]]".formatted(label, param.rawValues[0] >> 16 & 0xFF);
                case ParameterType.INLINE_TABLE_1 -> "inl[%1$s[%1$s[stor[%2$d]]]]".formatted(label, param.rawValues[0] >> 16 & 0xFF);
                case ParameterType.INLINE_TABLE_2 -> "inl[%1$s[%1$s[stor[%2$d]] + stor[%3$d]]]".formatted(label, param.rawValues[1] & 0xFF, param.rawValues[1] >> 8 & 0xFF);
                case ParameterType.INLINE_TABLE_3 -> "inl[%1$s + inl[%1$s + 0x%2$x]]".formatted(label, param.rawValues[0] >> 16 & 0xFF);
                case ParameterType._12 -> throw new RuntimeException("Param type 0x12 not yet supported");
                case ParameterType._15 -> throw new RuntimeException("Param type 0x15 not yet supported");
                case ParameterType._16 -> throw new RuntimeException("Param type 0x16 not yet supported");
                case ParameterType.INLINE_TABLE_4 -> "inl[%1$s[%1$s[%2$d] + %3$d]]".formatted(label, param.rawValues[1] & 0xFF, param.rawValues[1] >> 8 & 0xFF);
                default -> "inl[" + label + "]";
            };
        }
        return switch (param.type) {
            default -> throw new MatchException(null, null);
            case ParameterType.IMMEDIATE -> this.getImmediateParam(meta, op, paramIndex, param.rawValues[0]);
            case ParameterType.NEXT_IMMEDIATE -> this.getImmediateParam(meta, op, paramIndex, param.rawValues[1]);
            case ParameterType.STORAGE -> "stor[%d]".formatted(param.rawValues[0] & 0xFF);
            case ParameterType.OTHER_OTHER_STORAGE -> "stor[stor[stor[%d], %d], %d]".formatted(param.rawValues[0] & 0xFF, param.rawValues[0] >> 8 & 0xFF, param.rawValues[0] >> 16 & 0xFF);
            case ParameterType.OTHER_STORAGE_OFFSET -> "stor[stor[%d], %d + stor[%d]]".formatted(param.rawValues[0] & 0xFF, param.rawValues[0] >> 8 & 0xFF, param.rawValues[0] >> 16 & 0xFF);
            case ParameterType.GAMEVAR_1 -> "var[%d]".formatted(param.rawValues[0] & 0xFF);
            case ParameterType.GAMEVAR_2 -> "var[%d + stor[%d]]".formatted(param.rawValues[0] & 0xFF, param.rawValues[0] >> 8 & 0xFF);
            case ParameterType.GAMEVAR_ARRAY_1 -> "var[%d][stor[%d]]".formatted(param.rawValues[0] & 0xFF, param.rawValues[0] >> 8 & 0xFF);
            case ParameterType.GAMEVAR_ARRAY_2 -> "var[%d + stor[%d]][stor[%d]]".formatted(param.rawValues[0] & 0xFF, param.rawValues[0] >> 8 & 0xFF, param.rawValues[0] >> 16 & 0xFF);
            case ParameterType.INLINE_1 -> "inl[0x%x]".formatted(op.address + (short)param.rawValues[0] * 4);
            case ParameterType.INLINE_2 -> "inl[0x%x[stor[%d]]]".formatted(op.address + (short)param.rawValues[0] * 4, param.rawValues[0] >> 16 & 0xFF);
            case ParameterType.INLINE_TABLE_1 -> "inl[0x%1$x[0x%1$x[stor[%2$d]]]]".formatted(op.address + (short)param.rawValues[0] * 4, param.rawValues[0] >> 16 & 0xFF);
            case ParameterType.INLINE_TABLE_2 -> "inl[0x%1$x[0x%1$x[stor[%2$d]] + stor[%3$d]]]".formatted(op.address, param.rawValues[1] & 0xFF, param.rawValues[1] >> 8 & 0xFF);
            case ParameterType.OTHER_STORAGE -> "stor[stor[%d], %d]".formatted(param.rawValues[0] & 0xFF, param.rawValues[0] >> 8 & 255 + param.rawValues[0] >> 16 & 0xFF);
            case ParameterType.GAMEVAR_3 -> "var[%d + %d]".formatted(param.rawValues[0] & 0xFF, param.rawValues[0] >> 8 & 0xFF);
            case ParameterType.GAMEVAR_ARRAY_3 -> "var[%d][%d]".formatted(param.rawValues[0] & 0xFF, param.rawValues[0] >> 8 & 0xFF);
            case ParameterType.GAMEVAR_ARRAY_4 -> "var[%d + stor[%d]][%d]".formatted(param.rawValues[0] & 0xFF, param.rawValues[0] >> 8 & 0xFF, param.rawValues[0] >> 16 & 0xFF);
            case ParameterType.GAMEVAR_ARRAY_5 -> "var[%d + %d][stor[%d]]".formatted(param.rawValues[0] & 0xFF, param.rawValues[0] >> 8 & 0xFF, param.rawValues[0] >> 16 & 0xFF);
            case ParameterType._12 -> throw new RuntimeException("Param type 0x12 not yet supported");
            case ParameterType.INLINE_3 -> "inl[0x%x]".formatted(op.address + ((short)param.rawValues[0] + param.rawValues[0] >> 16 & 0xFF) * 4);
            case ParameterType.INLINE_TABLE_3 -> "inl[0x%1$x[inl[0x%1$x + 0x%2$x]]]".formatted(op.address + (short)param.rawValues[0] * 4, (param.rawValues[0] >> 16 & 0xFF) * 4);
            case ParameterType._15 -> throw new RuntimeException("Param type 0x15 not yet supported");
            case ParameterType._16 -> throw new RuntimeException("Param type 0x16 not yet supported");
            case ParameterType.INLINE_TABLE_4 -> "inl[0x%1$x[0x%1$x[%2$d] + %3$d]]".formatted(op.address, param.rawValues[1] & 0xFF, param.rawValues[1] >> 8 & 0xFF);
            case ParameterType.REG -> "reg[%d]".formatted(param.rawValues[0] & 0xFF);
            case ParameterType.ID -> {
                char[] chars = new char[param.rawValues[0] >>> 16 & 0xFF];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = (char)(param.rawValues[1 + i / 4] >>> i % 4 * 8 & 0xFF);
                }
                String id = new String(chars);
                yield "id[" + id + "]";
            }
            case ParameterType.REG_NULL -> "null";
            case ParameterType.REG_VAR -> "reg[stor[%d]]".formatted(param.rawValues[0] & 0xFF);
        };
    }

    private String getImmediateParam(Meta meta, Op op, int paramIndex, int value) {
        if (op.type == OpType.CALL && meta.enums.containsKey(meta.methods[op.headerParam].params[paramIndex].type)) {
            return meta.enums.get(meta.methods[op.headerParam].params[paramIndex].type)[value];
        }
        return "0x%x".formatted(value);
    }
}

