/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting.meta;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.legendofdragoon.scripting.meta.Meta;
import org.legendofdragoon.scripting.meta.NoSuchVersionException;

public class MetaManager {
    private final URI baseUri;
    private final Path cacheDir;
    private String[] versions;

    public MetaManager(URI baseUri, Path cacheDir) {
        this.baseUri = baseUri;
        this.cacheDir = cacheDir;
    }

    public String[] getVersions() throws IOException, CsvException {
        if (this.versions == null) {
            this.versions = this.requestCsv(this.baseUri.resolve("versions.php").toURL()).getFirst();
        }
        return this.versions;
    }

    public Meta loadMeta(String version) throws IOException, CsvException, NoSuchVersionException {
        if ("snapshot".equals(version)) {
            return this.loadMeta(this.baseUri.resolve(version + "/"), null);
        }
        Path versionDir = this.cacheDir.resolve(version);
        if (Files.exists(versionDir, new LinkOption[0])) {
            return this.loadMeta(versionDir);
        }
        List<String> versions = Arrays.asList(this.getVersions());
        if (!versions.contains(version)) {
            throw new NoSuchVersionException("Invalid version: " + version);
        }
        return this.loadMeta(this.baseUri.resolve(version + "/"), this.cacheDir.resolve(version));
    }

    private Meta loadMeta(Path basePath) throws IOException, CsvException {
        List<String[]> descriptionsCsv = this.loadCsvFile(basePath.resolve("descriptions.csv"));
        List<String[]> paramsCsv = this.loadCsvFile(basePath.resolve("params.csv"));
        List<String[]> enumsCsv = this.loadCsvFile(basePath.resolve("enums.csv"));
        ArrayList<Meta.ScriptMethod> methods = new ArrayList<Meta.ScriptMethod>();
        ArrayList<String> enumClasses = new ArrayList<String>();
        this.loadMeta(descriptionsCsv, paramsCsv, enumsCsv, methods, enumClasses);
        Meta.ScriptMethod[] methodsArr = (Meta.ScriptMethod[])methods.toArray(Meta.ScriptMethod[]::new);
        HashMap<String, String[]> enums = new HashMap<String, String[]>();
        for (String className : enumClasses) {
            String[] values = (String[])this.loadCsvFile(basePath.resolve(className + ".csv")).stream().map(v -> v[0]).toArray(String[]::new);
            enums.put(className, values);
        }
        return new Meta(methodsArr, enums);
    }

    private Meta loadMeta(URI uri, Path cache) throws IOException, CsvException {
        List<String[]> descriptionsCsv = this.requestCsv(uri.resolve("descriptions.csv").toURL(), this.child(cache, "descriptions.csv"));
        List<String[]> paramsCsv = this.requestCsv(uri.resolve("params.csv").toURL(), this.child(cache, "params.csv"));
        List<String[]> enumsCsv = this.requestCsv(uri.resolve("enums.csv").toURL(), this.child(cache, "enums.csv"));
        ArrayList<Meta.ScriptMethod> methods = new ArrayList<Meta.ScriptMethod>();
        ArrayList<String> enumClasses = new ArrayList<String>();
        this.loadMeta(descriptionsCsv, paramsCsv, enumsCsv, methods, enumClasses);
        Meta.ScriptMethod[] methodsArr = (Meta.ScriptMethod[])methods.toArray(Meta.ScriptMethod[]::new);
        HashMap<String, String[]> enums = new HashMap<String, String[]>();
        for (String className : enumClasses) {
            String[] values = (String[])this.requestCsv(uri.resolve(className + ".csv").toURL(), this.child(cache, className + ".csv")).stream().map(v -> v[0]).toArray(String[]::new);
            enums.put(className, values);
        }
        return new Meta(methodsArr, enums);
    }

    private void loadMeta(List<String[]> descriptionsCsv, List<String[]> paramsCsv, List<String[]> enumsCsv, List<Meta.ScriptMethod> methods, List<String> enumClasses) {
        for (String[] description : descriptionsCsv) {
            ArrayList<Meta.ScriptParam> params = new ArrayList<Meta.ScriptParam>();
            for (String[] param : paramsCsv) {
                if (!param[0].equals(description[0])) continue;
                params.add(new Meta.ScriptParam(param[1], param[2], param[3], param[4], param[5]));
            }
            methods.add(new Meta.ScriptMethod(description[0], description[1], (Meta.ScriptParam[])params.toArray(Meta.ScriptParam[]::new)));
        }
        for (String[] val : enumsCsv) {
            String className = val[0];
            enumClasses.add(className);
        }
    }

    private Path child(Path path, String child) {
        if (path == null) {
            return null;
        }
        return path.resolve(child);
    }

    private List<String[]> requestCsv(URL url) throws IOException, CsvException {
        return this.requestCsv(url, null);
    }

    private List<String[]> requestCsv(URL url, Path cache) throws IOException, CsvException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        if (con.getResponseCode() != 200) {
            throw new RuntimeException("Failed to download meta " + String.valueOf(url) + ": " + con.getResponseCode() + " - " + con.getResponseMessage());
        }
        InputStream stream = con.getInputStream();
        byte[] data = stream.readAllBytes();
        if (cache != null) {
            Files.createDirectories(cache.getParent(), new FileAttribute[0]);
            Files.write(cache, data, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        List<String[]> csv = this.loadCsv(new ByteArrayInputStream(data));
        con.disconnect();
        return csv;
    }

    private List<String[]> loadCsvFile(Path file) throws IOException, CsvException {
        return this.loadCsv(Files.newInputStream(file, new OpenOption[0]));
    }

    private List<String[]> loadCsv(InputStream input) throws IOException, CsvException {
        try (CSVReader reader = new CSVReader((Reader)new InputStreamReader(input));){
            List list = reader.readAll();
            return list;
        }
    }
}

