/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting.resolution;

import java.util.function.IntConsumer;
import org.legendofdragoon.scripting.resolution.Register;

public interface ResolvedValue {
    public boolean isPresent();

    public int get();

    default public boolean isRange() {
        return false;
    }

    default public int min() {
        throw new IllegalStateException("No value is present");
    }

    default public int max() {
        throw new IllegalStateException("No value is present");
    }

    default public void ifPresent(IntConsumer ifPresent) {
        if (this.isPresent()) {
            ifPresent.accept(this.get());
        }
    }

    default public void ifPresentOrElse(IntConsumer ifPresent, Runnable orElse) {
        if (this.isPresent()) {
            ifPresent.accept(this.get());
        } else {
            orElse.run();
        }
    }

    default public int orElse(int orElse) {
        if (!this.isPresent()) {
            return orElse;
        }
        return this.get();
    }

    public static ResolvedValue unresolved() {
        return new ResolvedValue(){

            @Override
            public boolean isPresent() {
                return false;
            }

            @Override
            public int get() {
                throw new IllegalStateException("No value is present");
            }
        };
    }

    public static ResolvedValue of(final int value) {
        return new ResolvedValue(){

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public int get() {
                return value;
            }
        };
    }

    public static ResolvedValue register(final Register register) {
        return new ResolvedValue(){

            @Override
            public boolean isPresent() {
                return register.isKnown();
            }

            @Override
            public int get() {
                return register.known().getAsInt();
            }

            @Override
            public boolean isRange() {
                return register.isRange();
            }

            @Override
            public int min() {
                return register.min().getAsInt();
            }

            @Override
            public int max() {
                return register.max().getAsInt();
            }
        };
    }
}

