/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.config;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyRuntimeException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import org.lenskit.LenskitConfiguration;
import org.lenskit.RecommenderConfigurationException;
import org.lenskit.config.ConfigurationLoader;
import org.lenskit.config.GroovyUtils;
import org.lenskit.config.LenskitConfigDSL;

public class ConfigHelpers {
    private ConfigHelpers() {
    }

    public static LenskitConfiguration load(@DelegatesTo(value=LenskitConfigDSL.class) Closure<?> block) throws RecommenderConfigurationException {
        Preconditions.checkNotNull(block, (Object)"Configuration block");
        LenskitConfiguration config = new LenskitConfiguration();
        ConfigHelpers.configure(config, block);
        return config;
    }

    @Deprecated
    public static LenskitConfiguration load(String script) throws RecommenderConfigurationException {
        return new ConfigurationLoader().load(script);
    }

    public static LenskitConfiguration load(File script) throws IOException, RecommenderConfigurationException {
        return new ConfigurationLoader().load(script);
    }

    public static LenskitConfiguration load(URL script) throws IOException, RecommenderConfigurationException {
        return new ConfigurationLoader().load(script);
    }

    public static void configure(LenskitConfiguration config, @Nonnull @DelegatesTo(value=LenskitConfigDSL.class) Closure<?> block) throws RecommenderConfigurationException {
        Preconditions.checkNotNull(block, (Object)"Configuration block");
        LenskitConfigDSL delegate = LenskitConfigDSL.forConfig(config);
        try {
            GroovyUtils.callWithDelegate(block, (Object)delegate);
        }
        catch (GroovyRuntimeException e) {
            if (((Object)((Object)e)).getClass().equals(GroovyRuntimeException.class) && e.getCause() != null) {
                throw new RecommenderConfigurationException("Error evaluating Groovy block", e.getCause());
            }
            throw new RecommenderConfigurationException("Error evaluating Groovy block", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new RecommenderConfigurationException("Error evaluating Groovy block", (Throwable)e);
        }
    }
}

