/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.config;

import com.google.common.base.Preconditions;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.grouplens.grapht.util.ClassLoaders;
import org.grouplens.lenskit.util.ClassDirectory;
import org.lenskit.LenskitConfiguration;
import org.lenskit.RecommenderConfigurationException;
import org.lenskit.config.ConfigHelpers;
import org.lenskit.config.LenskitConfigDSL;
import org.lenskit.config.LenskitConfigScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationLoader.class);
    private final ClassLoader classLoader;
    private final GroovyShell shell;
    private final Binding binding;
    private final ClassDirectory directory;
    private int scriptNumber;

    public ConfigurationLoader() {
        this(null);
    }

    public ConfigurationLoader(ClassLoader loader) {
        this.classLoader = loader != null ? loader : ClassLoaders.inferDefault(ConfigurationLoader.class);
        this.binding = new Binding();
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(LenskitConfigScript.class.getName());
        ImportCustomizer imports = new ImportCustomizer();
        imports.addStarImports(new String[]{"org.lenskit.api"});
        imports.addStarImports(new String[]{"org.lenskit.basic"});
        config.addCompilationCustomizers(new CompilationCustomizer[]{imports});
        this.shell = new GroovyShell(loader, this.binding, config);
        this.directory = ClassDirectory.forClassLoader((ClassLoader)this.classLoader);
    }

    public ClassDirectory getDirectory() {
        return this.directory;
    }

    public LenskitConfigScript loadScript(GroovyCodeSource source, URI base) throws RecommenderConfigurationException {
        LenskitConfigScript script;
        logger.info("loading script from {}", (Object)source.getName());
        try {
            script = (LenskitConfigScript)this.shell.parse(source);
        }
        catch (GroovyRuntimeException e) {
            throw new RecommenderConfigurationException("Error loading Groovy script", (Throwable)e);
        }
        script.setDelegate(new LenskitConfigDSL(this, base));
        return script;
    }

    public LenskitConfiguration load(@Nonnull File file) throws IOException, RecommenderConfigurationException {
        Preconditions.checkNotNull((Object)file, (Object)"Configuration file");
        return this.loadScript(file).configure();
    }

    public LenskitConfiguration load(@Nonnull URL url) throws IOException, RecommenderConfigurationException {
        Preconditions.checkNotNull((Object)url, (Object)"Configuration URL");
        return this.loadScript(url).configure();
    }

    @Deprecated
    public LenskitConfiguration load(@Nonnull String source) throws RecommenderConfigurationException {
        Preconditions.checkNotNull((Object)source, (Object)"Configuration source text");
        return this.loadScript(source).configure();
    }

    public LenskitConfigScript loadScript(@Nonnull File file) throws IOException, RecommenderConfigurationException {
        Preconditions.checkNotNull((Object)file, (Object)"Configuration file");
        return this.loadScript(new GroovyCodeSource(file), file.toURI());
    }

    public LenskitConfigScript loadScript(@Nonnull URL url) throws IOException, RecommenderConfigurationException {
        Preconditions.checkNotNull((Object)url, (Object)"Configuration URL");
        try {
            return this.loadScript(new GroovyCodeSource(url), url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI", e);
        }
    }

    public LenskitConfigScript loadScript(@Nonnull String source) throws RecommenderConfigurationException {
        Preconditions.checkNotNull((Object)source, (Object)"Configuration source text");
        return this.loadScript(new GroovyCodeSource(source, "LKConfig" + ++this.scriptNumber, "/groovy/shell"), null);
    }

    @Deprecated
    public LenskitConfiguration load(@Nonnull Closure<?> block) throws RecommenderConfigurationException {
        return ConfigHelpers.load(block);
    }
}

