/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.config;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.SystemUtils;
import org.lenskit.LenskitConfigContext;
import org.lenskit.LenskitConfiguration;
import org.lenskit.RecommenderConfigurationException;
import org.lenskit.config.BindingDSL;
import org.lenskit.config.ConfigurationLoader;
import org.lenskit.config.LenskitConfigScript;

public class LenskitConfigDSL
extends BindingDSL {
    private final LenskitConfiguration config;
    private final ConfigurationLoader configLoader;
    private URI baseURI;

    public LenskitConfigDSL(ConfigurationLoader loader) {
        this(loader, null);
    }

    public LenskitConfigDSL(ConfigurationLoader loader, URI base) {
        this(loader, new LenskitConfiguration(), base);
    }

    protected LenskitConfigDSL(ConfigurationLoader loader, LenskitConfiguration cfg, URI base) {
        super((LenskitConfigContext)cfg);
        this.config = cfg;
        this.configLoader = loader;
        this.baseURI = base == null ? new File(System.getProperty("user.dir")).toURI() : base;
    }

    static LenskitConfigDSL forConfig(LenskitConfiguration cfg) {
        return new LenskitConfigDSL(null, cfg, null);
    }

    public LenskitConfiguration getConfig() {
        return this.config;
    }

    public ConfigurationLoader getConfigLoader() {
        if (this.configLoader == null) {
            throw new IllegalStateException("no configuration loader specified");
        }
        return this.configLoader;
    }

    @Nonnull
    public URI getBaseURI() {
        if (this.baseURI == null) {
            return SystemUtils.getUserDir().toURI();
        }
        return this.baseURI;
    }

    public void setBaseURI(URI base) {
        this.baseURI = base;
    }

    public void root(Class<?> type) {
        this.config.addRoot(type);
    }

    @Override
    public void include(URI uri) throws IOException, RecommenderConfigurationException {
        URI realURI = uri;
        if (!realURI.isAbsolute()) {
            realURI = this.getBaseURI().resolve(realURI);
        }
        LenskitConfigScript script = this.getConfigLoader().loadScript(realURI.toURL());
        script.configure(this.getConfig());
    }
}

