/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.config;

import com.google.common.base.Joiner;
import groovy.lang.Binding;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.lenskit.LenskitConfiguration;
import org.lenskit.RecommenderConfigurationException;
import org.lenskit.config.LenskitConfigDSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LenskitConfigScript
extends Script {
    protected final Logger logger = LoggerFactory.getLogger(LenskitConfigScript.class);
    private LenskitConfigDSL delegate;
    private Map<String, Set<String>> badProperties = new LinkedHashMap<String, Set<String>>();

    protected LenskitConfigScript() {
        this(new Binding());
    }

    protected LenskitConfigScript(Binding binding) {
        super(binding);
    }

    public LenskitConfiguration getConfig() {
        return this.delegate.getConfig();
    }

    public LenskitConfigDSL getDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("no delegate set");
        }
        return this.delegate;
    }

    public void setDelegate(LenskitConfigDSL dsl) {
        this.delegate = dsl;
    }

    public Object methodMissing(String name, Object args) {
        try {
            return InvokerHelper.invokeMethod((Object)((Object)this.getDelegate()), (String)name, (Object)args);
        }
        catch (MissingMethodException mme) {
            throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), mme.getArguments());
        }
    }

    public Object propertyMissing(String name) {
        if (Character.isUpperCase(name.charAt(0))) {
            this.logger.error("unresolved class or property {}", (Object)name);
            Set packages = this.delegate.getConfigLoader().getDirectory().getPackages(name);
            this.logger.debug("found {} packages with classes named {}", (Object)packages.size(), (Object)name);
            this.badProperties.put(name, packages);
            return null;
        }
        this.logger.error("unresolved property {} in configuration script", (Object)name);
        throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
    }

    private void runScript() throws RecommenderConfigurationException {
        this.badProperties.clear();
        try {
            this.run();
        }
        catch (RecommenderConfigurationException rce) {
            throw rce;
        }
        catch (Exception ex) {
            throw new RecommenderConfigurationException("error configuring recommender", (Throwable)ex);
        }
        if (!this.badProperties.isEmpty()) {
            for (Map.Entry<String, Set<String>> bpe : this.badProperties.entrySet()) {
                this.logger.error("Script references unknown class or property {}", (Object)bpe.getKey());
                for (String pkg : bpe.getValue()) {
                    this.logger.info("consider importing {}.{}", (Object)pkg, (Object)bpe.getKey());
                }
            }
            String message = "Unresolved properties in evaluation script: ";
            message = message + Joiner.on((String)", ").join(this.badProperties.keySet());
            throw new RecommenderConfigurationException(message);
        }
    }

    public void configure(LenskitConfiguration config) throws RecommenderConfigurationException {
        LenskitConfigDSL old = this.getDelegate();
        this.setDelegate(new LenskitConfigDSL(old.getConfigLoader(), config, this.delegate.getBaseURI()));
        try {
            this.runScript();
        }
        finally {
            this.setDelegate(old);
        }
    }

    public LenskitConfiguration configure() throws RecommenderConfigurationException {
        this.runScript();
        return this.delegate.getConfig();
    }
}

