/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item;

import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.lenskit.knn.item.ItemItemResult;
import org.lenskit.transform.normalize.VectorTransformation;

public abstract class ItemItemScoreAccumulator {
    private ItemItemScoreAccumulator() {
    }

    public abstract void add(long var1, double var3, int var5, double var6);

    public abstract void applyReversedTransform(VectorTransformation var1);

    static ItemItemScoreAccumulator basic(Long2DoubleMap receiver) {
        return new BasicAccumulator(receiver);
    }

    static ItemItemScoreAccumulator detailed(List<ItemItemResult> receiver) {
        return new DetailedAccumulator(receiver);
    }

    private static class DetailedAccumulator
    extends ItemItemScoreAccumulator {
        private final LongSet itemIds = new LongOpenHashSet();
        private final List<ItemItemResult> receiver;

        DetailedAccumulator(List<ItemItemResult> recv) {
            this.receiver = recv;
            for (ItemItemResult res : recv) {
                this.itemIds.add(res.getId());
            }
        }

        @Override
        public void add(long item, double score, int nnbrs, double weight) {
            this.receiver.add(new ItemItemResult(item, score, nnbrs, weight));
            this.itemIds.add(item);
        }

        @Override
        public void applyReversedTransform(VectorTransformation transform) {
            MutableSparseVector vec = MutableSparseVector.create((Collection)this.itemIds);
            for (ItemItemResult res : this.receiver) {
                vec.set(res.getId(), res.getScore());
            }
            transform.unapply(vec);
            int n = this.receiver.size();
            for (int i = 0; i < n; ++i) {
                ItemItemResult res = this.receiver.get(i);
                this.receiver.set(i, res.rescore(vec.get(res.getId())));
            }
        }
    }

    private static class BasicAccumulator
    extends ItemItemScoreAccumulator {
        private final Long2DoubleMap receiver;

        BasicAccumulator(Long2DoubleMap recv) {
            this.receiver = recv;
        }

        @Override
        public void add(long item, double score, int nnbrs, double weight) {
            this.receiver.put(item, score);
        }

        @Override
        public void applyReversedTransform(VectorTransformation transform) {
            MutableSparseVector vec = MutableSparseVector.create((Map)this.receiver);
            transform.unapply(vec);
            this.receiver.putAll((Map)vec.asMap());
        }
    }
}

