/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item;

import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.lenskit.api.ResultMap;
import org.lenskit.basic.AbstractItemScorer;
import org.lenskit.data.ratings.RatingVectorPDAO;
import org.lenskit.knn.MinNeighbors;
import org.lenskit.knn.NeighborhoodSize;
import org.lenskit.knn.item.ItemItemResult;
import org.lenskit.knn.item.ItemItemScoreAccumulator;
import org.lenskit.knn.item.NeighborhoodScorer;
import org.lenskit.knn.item.model.ItemItemModel;
import org.lenskit.results.Results;
import org.lenskit.transform.normalize.UserVectorNormalizer;
import org.lenskit.transform.normalize.VectorTransformation;
import org.lenskit.util.TopNScoredIdAccumulator;
import org.lenskit.util.UnlimitedScoredIdAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemItemScorer
extends AbstractItemScorer {
    private static final Logger logger = LoggerFactory.getLogger(ItemItemScorer.class);
    public static final Symbol NEIGHBORHOOD_SIZE_SYMBOL = Symbol.of((String)"org.grouplens.lenskit.knn.item.neighborhoodSize");
    protected final ItemItemModel model;
    private final RatingVectorPDAO rvDAO;
    @Nonnull
    protected final UserVectorNormalizer normalizer;
    @Nonnull
    protected final NeighborhoodScorer scorer;
    private final int neighborhoodSize;
    private final int minNeighbors;

    @Inject
    public ItemItemScorer(RatingVectorPDAO dao, ItemItemModel m, NeighborhoodScorer scorer, UserVectorNormalizer norm, @NeighborhoodSize int nnbrs, @MinNeighbors int min) {
        this.rvDAO = dao;
        this.model = m;
        this.scorer = scorer;
        this.normalizer = norm;
        this.neighborhoodSize = nnbrs;
        this.minNeighbors = min;
        logger.debug("configured item-item scorer with scorer {}", (Object)scorer);
    }

    @Nonnull
    public UserVectorNormalizer getNormalizer() {
        return this.normalizer;
    }

    @Nonnull
    public Map<Long, Double> score(long user, @Nonnull Collection<Long> items) {
        logger.debug("scoring {} items for user {}", (Object)items.size(), (Object)user);
        Long2DoubleOpenHashMap results = new Long2DoubleOpenHashMap(items.size());
        ItemItemScoreAccumulator accum = ItemItemScoreAccumulator.basic((Long2DoubleMap)results);
        this.scoreItems(user, items, accum);
        return results;
    }

    @Nonnull
    public ResultMap scoreWithDetails(long user, @Nonnull Collection<Long> items) {
        logger.debug("scoring {} items for user {} with details", (Object)items.size(), (Object)user);
        ArrayList<ItemItemResult> results = new ArrayList<ItemItemResult>(items.size());
        ItemItemScoreAccumulator accum = ItemItemScoreAccumulator.detailed(results);
        this.scoreItems(user, items, accum);
        return Results.newResultMap(results);
    }

    private void scoreItems(long user, @Nonnull Collection<Long> items, ItemItemScoreAccumulator accum) {
        Long2DoubleMap ratings = this.rvDAO.userRatingVector(user);
        ImmutableSparseVector summary = ImmutableSparseVector.create((Map)ratings);
        logger.trace("user has {} ratings", (Object)summary.size());
        VectorTransformation transform = this.normalizer.makeTransformation(user, (SparseVector)summary);
        MutableSparseVector normed = summary.mutableCopy();
        transform.apply(normed);
        Long2DoubleMap itemScores = normed.asMap();
        LongIterator iter = LongIterators.asLongIterator(items.iterator());
        while (iter.hasNext()) {
            long item = iter.nextLong();
            this.scoreItem(itemScores, item, accum);
        }
        accum.applyReversedTransform(transform);
    }

    protected void scoreItem(Long2DoubleMap userData, long item, ItemItemScoreAccumulator accum) {
        Long2DoubleMap allNeighbors = this.model.getNeighbors(item);
        Object acc = this.neighborhoodSize > 0 ? new TopNScoredIdAccumulator(this.neighborhoodSize) : new UnlimitedScoredIdAccumulator();
        for (Long2DoubleMap.Entry nbr : allNeighbors.long2DoubleEntrySet()) {
            if (!userData.containsKey(nbr.getLongKey())) continue;
            acc.put(nbr.getLongKey(), nbr.getDoubleValue());
        }
        Long2DoubleMap neighborhood = acc.finishMap();
        assert (this.neighborhoodSize <= 0 || neighborhood.size() <= this.neighborhoodSize);
        if (neighborhood.size() < this.minNeighbors) {
            return;
        }
        logger.trace("scoring item {} with {} of {} neighbors", new Object[]{item, neighborhood.size(), allNeighbors.size()});
        this.scorer.score(item, neighborhood, userData, accum);
    }
}

