/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item.model;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.fastutil.longs.LongSortedSets;
import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.grouplens.grapht.annotation.DefaultProvider;
import org.grouplens.lenskit.vectors.SparseVector;
import org.lenskit.inject.Shareable;
import org.lenskit.knn.item.model.ItemItemBuildContextProvider;
import org.lenskit.util.keys.SortedKeyIndex;

@DefaultProvider(value=ItemItemBuildContextProvider.class)
@Shareable
public class ItemItemBuildContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private SortedKeyIndex items;
    @Nonnull
    private SparseVector[] itemVectors;
    @Nonnull
    private Long2ObjectMap<LongSortedSet> userItems;

    ItemItemBuildContext(@Nonnull SortedKeyIndex universe, @Nonnull SparseVector[] vectors, @Nonnull Long2ObjectMap<LongSortedSet> userItems) {
        this.userItems = userItems;
        this.items = universe;
        this.itemVectors = vectors;
    }

    @Nonnull
    public LongSortedSet getItems() {
        return this.items.keySet();
    }

    @Nonnull
    public SparseVector itemVector(long item) {
        int idx = this.items.tryGetIndex(item);
        Preconditions.checkArgument((idx >= 0 ? 1 : 0) != 0, (Object)"unknown item");
        return this.itemVectors[idx];
    }

    @Nonnull
    public LongSortedSet getUserItems(long user) {
        LongSortedSet items = (LongSortedSet)this.userItems.get(user);
        if (items == null) {
            items = LongSortedSets.EMPTY_SET;
        }
        return items;
    }

    @Deprecated
    public Iterable<ItemVecPair> getItemPairs() {
        return new Iterable<ItemVecPair>(){

            @Override
            public Iterator<ItemVecPair> iterator() {
                return ItemItemBuildContext.this.getItemPairIterator();
            }
        };
    }

    @Deprecated
    public Iterator<ItemVecPair> getItemPairIterator() {
        return new FastIteratorImpl((LongSortedSet)this.items.keySet(), (LongSortedSet)this.items.keySet());
    }

    public final class ItemVecPair {
        public long itemId1;
        public long itemId2;
        public SparseVector vec1;
        public SparseVector vec2;
        public boolean lastInRow;

        public void setItem1(long itemId1) {
            this.itemId1 = itemId1;
            this.vec1 = ItemItemBuildContext.this.itemVector(itemId1);
        }

        public void setItem2(long itemId2) {
            this.itemId2 = itemId2;
            this.vec2 = ItemItemBuildContext.this.itemVector(itemId2);
        }
    }

    private final class FastIteratorImpl
    implements Iterator<ItemVecPair> {
        private ItemVecPair itemVecPair;
        private LongIterator iter1;
        private LongSortedSet list2;
        private LongIterator iter2;

        public FastIteratorImpl(LongSortedSet list1, LongSortedSet list2) {
            this.itemVecPair = new ItemVecPair();
            this.iter1 = list1.iterator();
            if (this.iter1.hasNext()) {
                this.itemVecPair.setItem1(this.iter1.nextLong());
            }
            this.list2 = list2;
            this.iter2 = list2.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter1.hasNext() || this.iter2.hasNext();
        }

        @Override
        public ItemVecPair next() {
            if (!this.iter2.hasNext()) {
                this.itemVecPair.setItem1(this.iter1.nextLong());
                this.iter2 = this.list2.iterator();
            }
            this.itemVecPair.setItem2(this.iter2.nextLong());
            this.itemVecPair.lastInRow = !this.iter2.hasNext();
            return this.itemVecPair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

