/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item.model;

import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.grouplens.lenskit.scored.ScoredIdListBuilder;
import org.grouplens.lenskit.scored.ScoredIds;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;
import org.lenskit.data.ratings.RatingVectorPDAO;
import org.lenskit.inject.Transient;
import org.lenskit.knn.item.model.ItemItemBuildContext;
import org.lenskit.transform.normalize.UserVectorNormalizer;
import org.lenskit.util.IdBox;
import org.lenskit.util.collections.LongUtils;
import org.lenskit.util.io.ObjectStream;
import org.lenskit.util.keys.SortedKeyIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemItemBuildContextProvider
implements Provider<ItemItemBuildContext> {
    private static final Logger logger = LoggerFactory.getLogger(ItemItemBuildContextProvider.class);
    private final RatingVectorPDAO rvDAO;
    private final UserVectorNormalizer normalizer;

    @Inject
    public ItemItemBuildContextProvider(@Transient RatingVectorPDAO rvd, @Transient UserVectorNormalizer normalizer) {
        this.rvDAO = rvd;
        this.normalizer = normalizer;
    }

    public ItemItemBuildContext get() {
        logger.info("constructing build context");
        logger.debug("using normalizer {}", (Object)this.normalizer);
        logger.debug("Building item data");
        Long2ObjectOpenHashMap itemRatingData = new Long2ObjectOpenHashMap(1000);
        Long2ObjectOpenHashMap userItems = new Long2ObjectOpenHashMap(1000);
        this.buildItemRatings((Long2ObjectMap<ScoredIdListBuilder>)itemRatingData, (Long2ObjectMap<LongSortedSet>)userItems);
        SortedKeyIndex items = SortedKeyIndex.fromCollection((Collection)itemRatingData.keySet());
        int n = items.size();
        assert (n == itemRatingData.size());
        SparseVector[] itemRatings = new SparseVector[n];
        for (int i = 0; i < n; ++i) {
            long item = items.getKey(i);
            ScoredIdListBuilder ratings = (ScoredIdListBuilder)itemRatingData.get(item);
            ImmutableSparseVector v = ratings.buildVector();
            assert (v.size() == ratings.size());
            itemRatings[i] = v;
            ratings.clear();
        }
        logger.debug("item data completed");
        return new ItemItemBuildContext(items, itemRatings, (Long2ObjectMap<LongSortedSet>)userItems);
    }

    private void buildItemRatings(Long2ObjectMap<ScoredIdListBuilder> itemRatings, Long2ObjectMap<LongSortedSet> userItems) {
        try (ObjectStream stream = this.rvDAO.streamUsers();){
            for (IdBox user : stream) {
                long uid = user.getId();
                Long2DoubleMap ratings = (Long2DoubleMap)user.getValue();
                ImmutableSparseVector summary = ImmutableSparseVector.create((Map)ratings);
                MutableSparseVector normed = summary.mutableCopy();
                this.normalizer.normalize(uid, (SparseVector)summary, normed);
                for (VectorEntry rating : normed) {
                    long item = rating.getKey();
                    ScoredIdListBuilder ivect = (ScoredIdListBuilder)itemRatings.get(item);
                    if (ivect == null) {
                        ivect = ScoredIds.newListBuilder((int)100);
                        itemRatings.put(item, (Object)ivect);
                    }
                    ivect.add(uid, rating.getValue());
                }
                userItems.put(uid, (Object)LongUtils.packedSet((Collection)summary.keySet()));
            }
        }
    }
}

