/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item.model;

import com.google.common.base.MoreObjects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.grouplens.lenskit.transform.threshold.Threshold;
import org.grouplens.lenskit.transform.truncate.ThresholdTruncator;
import org.grouplens.lenskit.transform.truncate.TopNTruncator;
import org.grouplens.lenskit.transform.truncate.VectorTruncator;
import org.lenskit.knn.item.ItemSimilarityThreshold;
import org.lenskit.knn.item.ModelSize;

public class StandardVectorTruncatorProvider
implements Provider<VectorTruncator> {
    private final Threshold threshold;
    private final int modelSize;

    @Inject
    public StandardVectorTruncatorProvider(@ItemSimilarityThreshold Threshold thresh, @ModelSize int msize) {
        this.threshold = thresh;
        this.modelSize = msize;
    }

    public VectorTruncator get() {
        if (this.modelSize > 0) {
            return new TopNTruncator(this.modelSize, this.threshold);
        }
        return new ThresholdTruncator(this.threshold);
    }

    public String toString() {
        return MoreObjects.toStringHelper(StandardVectorTruncatorProvider.class).add("modelSize", this.modelSize).add("threshold", (Object)this.threshold).toString();
    }
}

