/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.user;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.grouplens.lenskit.transform.threshold.Threshold;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.lenskit.data.dao.DataAccessObject;
import org.lenskit.data.entities.CommonAttributes;
import org.lenskit.data.entities.CommonTypes;
import org.lenskit.data.ratings.RatingVectorPDAO;
import org.lenskit.knn.user.Neighbor;
import org.lenskit.knn.user.NeighborFinder;
import org.lenskit.knn.user.UserSimilarity;
import org.lenskit.knn.user.UserSimilarityThreshold;
import org.lenskit.transform.normalize.UserVectorNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveNeighborFinder
implements NeighborFinder {
    private static final Logger logger = LoggerFactory.getLogger(LiveNeighborFinder.class);
    private final UserSimilarity similarity;
    private final RatingVectorPDAO rvDAO;
    private final DataAccessObject dao;
    private final UserVectorNormalizer normalizer;
    private final Threshold threshold;

    @Inject
    public LiveNeighborFinder(RatingVectorPDAO rvd, DataAccessObject dao, UserSimilarity sim, UserVectorNormalizer norm, @UserSimilarityThreshold Threshold thresh) {
        this.similarity = sim;
        this.normalizer = norm;
        this.rvDAO = rvd;
        this.dao = dao;
        this.threshold = thresh;
        Preconditions.checkArgument((boolean)sim.isSparse(), (Object)"user similarity function is not sparse");
    }

    @Override
    public Iterable<Neighbor> getCandidateNeighbors(final long user, LongSet items) {
        Long2DoubleMap ratings = this.rvDAO.userRatingVector(user);
        if (ratings.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableSparseVector urs = ImmutableSparseVector.create((Map)ratings);
        final ImmutableSparseVector nratings = this.normalizer.normalize(user, (SparseVector)urs, null).freeze();
        final LongSet candidates = this.findCandidateNeighbors(user, (SparseVector)nratings, (LongCollection)items);
        logger.debug("found {} candidate neighbors for {}", (Object)candidates.size(), (Object)user);
        return new Iterable<Neighbor>(){

            @Override
            public Iterator<Neighbor> iterator() {
                return new NeighborIterator(user, (SparseVector)nratings, candidates);
            }
        };
    }

    private LongSet findCandidateNeighbors(long user, SparseVector uvec, LongCollection itemSet) {
        LongOpenHashSet users = new LongOpenHashSet(100);
        LongSortedSet userItems = uvec.keySet();
        LongIterator items = userItems.size() < itemSet.size() ? userItems.iterator() : itemSet.iterator();
        while (items.hasNext()) {
            LongSet iusers = this.dao.query(CommonTypes.RATING).withAttribute(CommonAttributes.ITEM_ID, (Object)items.nextLong()).valueSet(CommonAttributes.USER_ID);
            if (iusers == null) continue;
            users.addAll((LongCollection)iusers);
        }
        users.remove(user);
        return users;
    }

    private boolean acceptSimilarity(double sim) {
        return !Double.isNaN(sim) && !Double.isInfinite(sim) && this.threshold.retain(sim);
    }

    private MutableSparseVector getUserRatingVector(long user) {
        Long2DoubleMap ratings = this.rvDAO.userRatingVector(user);
        if (ratings.isEmpty()) {
            return null;
        }
        return MutableSparseVector.create((Map)ratings);
    }

    private class NeighborIterator
    extends AbstractIterator<Neighbor> {
        private final long user;
        private final SparseVector userVector;
        private final LongIterator neighborIter;

        public NeighborIterator(long uid, SparseVector uvec, LongSet nbrs) {
            this.user = uid;
            this.userVector = uvec;
            this.neighborIter = nbrs.iterator();
        }

        protected Neighbor computeNext() {
            while (this.neighborIter.hasNext()) {
                long neighbor = this.neighborIter.nextLong();
                MutableSparseVector nbrRatings = LiveNeighborFinder.this.getUserRatingVector(neighbor);
                if (nbrRatings == null) continue;
                ImmutableSparseVector rawRatings = nbrRatings.immutable();
                LiveNeighborFinder.this.normalizer.normalize(neighbor, (SparseVector)rawRatings, nbrRatings);
                double sim = LiveNeighborFinder.this.similarity.similarity(this.user, this.userVector, neighbor, (SparseVector)nbrRatings);
                if (!LiveNeighborFinder.this.acceptSimilarity(sim)) continue;
                return new Neighbor(neighbor, (SparseVector)rawRatings, sim);
            }
            return (Neighbor)this.endOfData();
        }
    }
}

