/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.user;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Provider;
import org.grouplens.grapht.annotation.DefaultProvider;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.lenskit.data.ratings.RatingVectorPDAO;
import org.lenskit.inject.Shareable;
import org.lenskit.inject.Transient;
import org.lenskit.transform.normalize.UserVectorNormalizer;
import org.lenskit.util.IdBox;
import org.lenskit.util.collections.LongUtils;
import org.lenskit.util.io.ObjectStream;
import org.lenskit.util.keys.SortedKeyIndex;

@Shareable
@DefaultProvider(value=Builder.class)
@ThreadSafe
public class UserSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SortedKeyIndex users;
    private final List<ImmutableSparseVector> vectors;
    private final List<ImmutableSparseVector> normedVectors;
    private final Long2ObjectMap<LongSortedSet> itemUserSets;

    UserSnapshot(SortedKeyIndex us, List<ImmutableSparseVector> vs, List<ImmutableSparseVector> nvs, Long2ObjectMap<LongSortedSet> iuSets) {
        Preconditions.checkArgument((vs.size() == us.size() ? 1 : 0) != 0, (Object)"incorrectly sized vector list");
        Preconditions.checkArgument((nvs.size() == us.size() ? 1 : 0) != 0, (Object)"incorrectly sized normalized vector list");
        this.users = us;
        this.vectors = ImmutableList.copyOf(vs);
        this.normedVectors = ImmutableList.copyOf(nvs);
        this.itemUserSets = iuSets;
    }

    public ImmutableSparseVector getUserVector(long user) {
        int idx = this.users.tryGetIndex(user);
        Preconditions.checkArgument((idx >= 0 ? 1 : 0) != 0, (Object)("invalid user " + user));
        return this.vectors.get(idx);
    }

    public ImmutableSparseVector getNormalizedUserVector(long user) {
        int idx = this.users.tryGetIndex(user);
        Preconditions.checkArgument((idx >= 0 ? 1 : 0) != 0, (Object)("invalid user " + user));
        return this.normedVectors.get(idx);
    }

    public LongSet getItemUsers(long item) {
        return (LongSet)this.itemUserSets.get(item);
    }

    public static class Builder
    implements Provider<UserSnapshot> {
        private final RatingVectorPDAO rvDAO;
        private final UserVectorNormalizer normalizer;

        @Inject
        public Builder(@Transient RatingVectorPDAO rvd, @Transient UserVectorNormalizer norm) {
            this.rvDAO = rvd;
            this.normalizer = norm;
        }

        public UserSnapshot get() {
            Long2ObjectOpenHashMap vectors = new Long2ObjectOpenHashMap();
            try (ObjectStream users = this.rvDAO.streamUsers();){
                for (IdBox user : users) {
                    MutableSparseVector uvec = MutableSparseVector.create((Map)((Map)user.getValue()));
                    vectors.put(user.getId(), (Object)uvec);
                }
            }
            Long2ObjectOpenHashMap itemUserLists = new Long2ObjectOpenHashMap();
            SortedKeyIndex domain = SortedKeyIndex.fromCollection((Collection)vectors.keySet());
            ImmutableList.Builder vecs = ImmutableList.builder();
            ImmutableList.Builder nvecs = ImmutableList.builder();
            LongBidirectionalIterator uiter = domain.keyIterator();
            while (uiter.hasNext()) {
                long user = uiter.nextLong();
                MutableSparseVector vec = (MutableSparseVector)vectors.get(user);
                ImmutableSparseVector userVector = vec.immutable();
                vecs.add((Object)userVector);
                this.normalizer.normalize(user, (SparseVector)userVector, vec);
                nvecs.add((Object)vec.immutable());
                LongBidirectionalIterator iiter = userVector.keySet().iterator();
                while (iiter.hasNext()) {
                    long item = iiter.nextLong();
                    LongList itemUsers = (LongList)itemUserLists.get(item);
                    if (itemUsers == null) {
                        itemUsers = new LongArrayList();
                        itemUserLists.put(item, (Object)itemUsers);
                    }
                    itemUsers.add(user);
                }
            }
            Long2ObjectOpenHashMap itemUserSets = new Long2ObjectOpenHashMap();
            for (Long2ObjectMap.Entry entry : itemUserLists.long2ObjectEntrySet()) {
                itemUserSets.put(entry.getLongKey(), (Object)LongUtils.packedSet((Collection)((Collection)entry.getValue())));
            }
            return new UserSnapshot(domain, (List<ImmutableSparseVector>)vecs.build(), (List<ImmutableSparseVector>)nvecs.build(), (Long2ObjectMap<LongSortedSet>)itemUserSets);
        }
    }
}

