/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.user;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.grouplens.lenskit.transform.threshold.Threshold;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;
import org.lenskit.api.ResultMap;
import org.lenskit.basic.AbstractItemScorer;
import org.lenskit.data.ratings.RatingVectorPDAO;
import org.lenskit.knn.MinNeighbors;
import org.lenskit.knn.NeighborhoodSize;
import org.lenskit.knn.user.Neighbor;
import org.lenskit.knn.user.NeighborFinder;
import org.lenskit.knn.user.ResultBuilder;
import org.lenskit.knn.user.UserSimilarityThreshold;
import org.lenskit.knn.user.UserUserResult;
import org.lenskit.results.Results;
import org.lenskit.transform.normalize.UserVectorNormalizer;
import org.lenskit.transform.normalize.VectorTransformation;
import org.lenskit.util.collections.LongUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUserItemScorer
extends AbstractItemScorer {
    private static final Logger logger = LoggerFactory.getLogger(UserUserItemScorer.class);
    private final RatingVectorPDAO dao;
    protected final NeighborFinder neighborFinder;
    protected final UserVectorNormalizer normalizer;
    private final int neighborhoodSize;
    private final int minNeighborCount;
    private final Threshold userThreshold;

    @Inject
    public UserUserItemScorer(RatingVectorPDAO rvd, NeighborFinder nf, UserVectorNormalizer norm, @NeighborhoodSize int nnbrs, @MinNeighbors int minNbrs, @UserSimilarityThreshold Threshold thresh) {
        this.dao = rvd;
        this.neighborFinder = nf;
        this.normalizer = norm;
        this.neighborhoodSize = nnbrs;
        this.minNeighborCount = minNbrs;
        this.userThreshold = thresh;
    }

    protected Long2ObjectMap<SparseVector> normalizeNeighborRatings(Collection<? extends Collection<Neighbor>> neighborhoods) {
        Long2ObjectOpenHashMap normedVectors = new Long2ObjectOpenHashMap();
        for (Neighbor n : Iterables.concat(neighborhoods)) {
            if (normedVectors.containsKey(n.user)) continue;
            normedVectors.put(n.user, (Object)this.normalizer.normalize(n.user, n.vector, null));
        }
        return normedVectors;
    }

    @Nonnull
    public ResultMap scoreWithDetails(long user, @Nonnull Collection<Long> items) {
        Long2DoubleMap history = this.dao.userRatingVector(user);
        logger.debug("Predicting for {} items for user {} with {} events", new Object[]{items.size(), user, history.size()});
        LongSortedSet itemSet = LongUtils.packedSet(items);
        Long2ObjectMap<? extends Collection<Neighbor>> neighborhoods = this.findNeighbors(user, (LongSet)itemSet);
        Long2ObjectMap<SparseVector> normedUsers = this.normalizeNeighborRatings((Collection<? extends Collection<Neighbor>>)neighborhoods.values());
        ImmutableSparseVector urv = ImmutableSparseVector.create((Map)history);
        VectorTransformation vo = this.normalizer.makeTransformation(user, (SparseVector)urv);
        ArrayList<ResultBuilder> resultBuilders = new ArrayList<ResultBuilder>();
        LongBidirectionalIterator iter = itemSet.iterator();
        while (iter.hasNext()) {
            long item = iter.nextLong();
            double sum = 0.0;
            double weight = 0.0;
            int count = 0;
            Collection nbrs = (Collection)neighborhoods.get(item);
            if (nbrs != null) {
                for (Neighbor n : nbrs) {
                    weight += Math.abs(n.similarity);
                    sum += n.similarity * ((SparseVector)normedUsers.get(n.user)).get(item);
                    ++count;
                }
            }
            if (count < this.minNeighborCount || !(weight > 0.0)) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Total neighbor weight for item {} is {} from {} neighbors", new Object[]{item, weight, count});
            }
            resultBuilders.add(UserUserResult.newBuilder().setItemId(item).setRawScore(sum / weight).setNeighborhoodSize(count).setTotalWeight(weight));
        }
        MutableSparseVector vec = MutableSparseVector.create((Collection)itemSet);
        for (ResultBuilder rb : resultBuilders) {
            vec.set(rb.getItemId(), rb.getRawScore());
        }
        vo.unapply(vec);
        ArrayList<UserUserResult> results = new ArrayList<UserUserResult>(resultBuilders.size());
        for (ResultBuilder rb : resultBuilders) {
            results.add(rb.setScore(vec.get(rb.getItemId())).build());
        }
        return Results.newResultMap(results);
    }

    protected Long2ObjectMap<? extends Collection<Neighbor>> findNeighbors(long user, @Nonnull LongSet items) {
        Preconditions.checkNotNull((Object)user, (Object)"user profile");
        Preconditions.checkNotNull((Object)user, (Object)"item set");
        Long2ObjectOpenHashMap heaps = new Long2ObjectOpenHashMap(items.size());
        LongIterator iter = items.iterator();
        while (iter.hasNext()) {
            long item = iter.nextLong();
            heaps.put(item, new PriorityQueue<Neighbor>(this.neighborhoodSize + 1, Neighbor.SIMILARITY_COMPARATOR));
        }
        int neighborsUsed = 0;
        for (Neighbor nbr : this.neighborFinder.getCandidateNeighbors(user, items)) {
            for (VectorEntry e : nbr.vector) {
                long item = e.getKey();
                PriorityQueue heap = (PriorityQueue)heaps.get(item);
                if (heap == null) continue;
                heap.add(nbr);
                if (heap.size() > this.neighborhoodSize) {
                    assert (heap.size() == this.neighborhoodSize + 1);
                    heap.remove();
                    continue;
                }
                ++neighborsUsed;
            }
        }
        logger.debug("using {} neighbors across {} items", (Object)neighborsUsed, (Object)items.size());
        return heaps;
    }
}

