/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.external;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.grouplens.lenskit.util.io.LoggingStreamSlurper;
import org.lenskit.api.ItemScorer;
import org.lenskit.basic.PrecomputedItemScorer;
import org.lenskit.data.dao.EventDAO;
import org.lenskit.data.dao.ItemDAO;
import org.lenskit.data.dao.UserDAO;
import org.lenskit.data.ratings.Rating;
import org.lenskit.external.ExternalProcessException;
import org.lenskit.util.io.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalProcessItemScorerBuilder
implements Provider<ItemScorer> {
    private static final Logger logger = LoggerFactory.getLogger(ExternalProcessItemScorerBuilder.class);
    private static final String CHARSET_UTF_8 = "UTF-8";
    private File workingDir = new File(".");
    private String executable;
    private List<Supplier<String>> arguments = Lists.newArrayList();

    public ExternalProcessItemScorerBuilder setWorkingDir(File dir) {
        this.workingDir = dir;
        return this;
    }

    public ExternalProcessItemScorerBuilder setWorkingDir(String dir) {
        return this.setWorkingDir(new File(dir));
    }

    public ExternalProcessItemScorerBuilder setExecutable(String exe) {
        this.executable = exe;
        return this;
    }

    public ExternalProcessItemScorerBuilder addArgument(String arg) {
        this.arguments.add((Supplier<String>)Suppliers.ofInstance((Object)arg));
        return this;
    }

    public ExternalProcessItemScorerBuilder addArguments(Collection<String> args) {
        for (String arg : args) {
            this.addArgument(arg);
        }
        return this;
    }

    public ExternalProcessItemScorerBuilder addArguments(String ... args) {
        return this.addArguments(Arrays.asList(args));
    }

    public ExternalProcessItemScorerBuilder addRatingFileArgument(EventDAO ratings, @Nullable String name) {
        this.arguments.add(new RatingFileSupplier(ratings, name));
        return this;
    }

    public ExternalProcessItemScorerBuilder addRatingFileArgument(EventDAO ratings) {
        return this.addRatingFileArgument(ratings, null);
    }

    public ExternalProcessItemScorerBuilder addItemFileArgument(ItemDAO items, @Nullable String name) {
        this.arguments.add(new ItemFileSupplier(items, name));
        return this;
    }

    public ExternalProcessItemScorerBuilder addItemFileArgument(ItemDAO items) {
        return this.addItemFileArgument(items, null);
    }

    public ExternalProcessItemScorerBuilder addUserFileArgument(UserDAO users, @Nullable String name) {
        this.arguments.add(new UserFileSupplier(users, name));
        return this;
    }

    public ExternalProcessItemScorerBuilder addUserFileArgument(UserDAO users) {
        return this.addUserFileArgument(users, null);
    }

    public ItemScorer build() {
        int ec;
        PrecomputedItemScorer scorer;
        Process proc;
        Preconditions.checkState((this.executable != null ? 1 : 0) != 0, (Object)"no executable specified");
        ArrayList command = Lists.newArrayList();
        command.add(this.executable);
        for (Supplier<String> arg : this.arguments) {
            command.add(arg.get());
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(command).directory(this.workingDir);
        try {
            proc = pb.start();
        }
        catch (IOException e) {
            logger.error("could not start {}: {}", (Object)this.executable, (Object)e);
            throw new ExternalProcessException("could not start external process", e);
        }
        LoggingStreamSlurper slurp = new LoggingStreamSlurper("build-" + this.executable, proc.getErrorStream(), logger, "");
        slurp.start();
        try (InputStreamReader rdr = new InputStreamReader(proc.getInputStream(), Charsets.UTF_8);
             BufferedReader buf = new BufferedReader(rdr);){
            scorer = PrecomputedItemScorer.fromCSV((BufferedReader)buf);
        }
        catch (IOException e) {
            throw new ExternalProcessException("cannot open output", e);
        }
        try {
            ec = proc.waitFor();
        }
        catch (InterruptedException e) {
            proc.destroy();
            throw new ExternalProcessException("external process interrupted", e);
        }
        if (ec == 0) {
            return scorer;
        }
        logger.error("{} exited with code {}", (Object)this.executable, (Object)ec);
        throw new ExternalProcessException("external process failed with code " + ec);
    }

    public ItemScorer get() {
        return this.build();
    }

    private class UserFileSupplier
    extends IDFileSupplier {
        private final UserDAO userDAO;

        public UserFileSupplier(@Nullable UserDAO dao, String name) {
            super(name, "users");
            this.userDAO = dao;
        }

        @Override
        protected LongSet getIds() {
            return this.userDAO.getUserIds();
        }
    }

    private class ItemFileSupplier
    extends IDFileSupplier {
        private final ItemDAO itemDAO;

        public ItemFileSupplier(@Nullable ItemDAO dao, String name) {
            super(name, "items");
            this.itemDAO = dao;
        }

        @Override
        protected LongSet getIds() {
            return this.itemDAO.getItemIds();
        }
    }

    private abstract class IDFileSupplier
    implements Supplier<String> {
        private final String fileName;
        private final String prefix;

        IDFileSupplier(String name, String pfx) {
            this.fileName = name;
            this.prefix = pfx;
        }

        protected abstract LongSet getIds();

        public String get() {
            String name = this.fileName;
            if (name == null) {
                name = this.prefix + "-" + UUID.randomUUID().toString() + ".csv";
            }
            logger.info("writing {} to {}", (Object)this.prefix, (Object)name);
            File file = new File(ExternalProcessItemScorerBuilder.this.workingDir, name);
            try (PrintWriter writer = new PrintWriter(file, ExternalProcessItemScorerBuilder.CHARSET_UTF_8);){
                LongSet ids = this.getIds();
                LongIterator iter = ids.iterator();
                while (iter.hasNext()) {
                    writer.println(iter.nextLong());
                }
            }
            catch (IOException e) {
                throw new ExternalProcessException("Error creating ratings file", e);
            }
            return name;
        }
    }

    private class RatingFileSupplier
    implements Supplier<String> {
        private final EventDAO eventDAO;
        private final String fileName;

        public RatingFileSupplier(@Nullable EventDAO dao, String name) {
            this.eventDAO = dao;
            this.fileName = name;
        }

        public String get() {
            String name = this.fileName;
            if (name == null) {
                name = "ratings-" + UUID.randomUUID().toString() + ".csv";
            }
            logger.info("writing ratings to {}", (Object)name);
            File file = new File(ExternalProcessItemScorerBuilder.this.workingDir, name);
            try (PrintWriter writer = new PrintWriter(file, ExternalProcessItemScorerBuilder.CHARSET_UTF_8);
                 ObjectStream ratings = this.eventDAO.streamEvents(Rating.class);){
                for (Rating r : ratings) {
                    writer.printf("%d,%d,", r.getUserId(), r.getItemId());
                    if (r.hasValue()) {
                        writer.print(r.getValue());
                    }
                    writer.print(",");
                    long ts = r.getTimestamp();
                    if (ts >= 0L) {
                        writer.print(ts);
                    }
                    writer.println();
                }
            }
            catch (IOException e) {
                throw new ExternalProcessException("Error creating ratings file", e);
            }
            return name;
        }
    }
}

