/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.predict;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.lenskit.api.Result;
import org.lenskit.api.ResultMap;
import org.lenskit.basic.AbstractRatingPredictor;
import org.lenskit.data.dao.UserEventDAO;
import org.lenskit.data.history.UserHistory;
import org.lenskit.data.ratings.Rating;
import org.lenskit.results.Results;
import org.lenskit.util.collections.LongUtils;

public class KnownRatingRatingPredictor
extends AbstractRatingPredictor {
    private final UserEventDAO dao;

    @Inject
    public KnownRatingRatingPredictor(UserEventDAO uedao) {
        this.dao = uedao;
    }

    @Nonnull
    public ResultMap predictWithDetails(long user, @Nonnull Collection<Long> items) {
        UserHistory ratings = this.dao.getEventsForUser(user, Rating.class);
        if (ratings == null) {
            return Results.newResultMap((Result[])new Result[0]);
        }
        LongSortedSet wantedItems = LongUtils.packedSet(items);
        Long2ObjectOpenHashMap results = new Long2ObjectOpenHashMap();
        for (Rating r : ratings) {
            long item = r.getItemId();
            if (!wantedItems.contains(r.getItemId())) continue;
            if (r.hasValue()) {
                results.put(item, (Object)Results.create((long)item, (double)r.getValue()));
                continue;
            }
            results.remove(item);
        }
        return Results.newResultMap((Iterable)results.values());
    }
}

