/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.predict;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;
import org.lenskit.api.ItemScorer;
import org.lenskit.api.Result;
import org.lenskit.api.ResultMap;
import org.lenskit.basic.AbstractRatingPredictor;
import org.lenskit.basic.PredictionScorer;
import org.lenskit.results.RescoredResult;
import org.lenskit.results.Results;
import org.lenskit.transform.quantize.Quantizer;

public class QuantizedRatingPredictor
extends AbstractRatingPredictor {
    private final ItemScorer itemScorer;
    private final Quantizer quantizer;

    @Inject
    public QuantizedRatingPredictor(@PredictionScorer ItemScorer scorer, Quantizer q) {
        this.itemScorer = scorer;
        this.quantizer = q;
    }

    private void quantize(MutableSparseVector scores) {
        for (VectorEntry e : scores) {
            scores.set(e, this.quantizer.getIndexValue(this.quantizer.index(e.getValue())));
        }
    }

    @Nonnull
    public ResultMap predictWithDetails(long user, @Nonnull Collection<Long> items) {
        ResultMap scores = this.itemScorer.scoreWithDetails(user, items);
        ArrayList<RescoredResult> results = new ArrayList<RescoredResult>();
        for (Result raw : scores) {
            int idx = this.quantizer.index(raw.getScore());
            double score = this.quantizer.getIndexValue(idx);
            results.add(Results.rescore((Result)raw, (double)score));
        }
        return Results.newResultMap(results);
    }
}

